document.addEventListener("DOMContentLoaded", () => {
	const blocks = document.querySelectorAll(
		".universal-control-for-tahoma-block",
	);

	blocks.forEach((block) => {
		const statusEl = block.querySelector(".tahoma-status");
		const config = JSON.parse(block.dataset.config);

		const fetchData = async (endpoint, body) => {
			return await fetch(`/wp-json/tahoma/v1/${endpoint}`, {
				method: "POST",
				headers: {
					"Content-Type": "application/json",
					"X-WP-Nonce": config.nonce,
				},
				body: JSON.stringify(body),
			});
		};

		const updateStatus = async () => {
			try {
				const res = await fetchData("status", { deviceURL: config.deviceURL });
				const data = await res.json();
				if (data.status) statusEl.innerText = data.status;
			} catch (e) {
				statusEl.innerText = "Error";
			}
		};

		block.addEventListener("click", async () => {
			block.style.opacity = "0.5";
			statusEl.innerText = "...";
			try {
				await fetchData("execute", config);
				setTimeout(updateStatus, 3000);
			} catch (e) {
				statusEl.innerText = "Error";
			} finally {
				block.style.opacity = "1";
			}
		});

		updateStatus();
	});
});
