<?php
if (! defined('ABSPATH')) exit;

$universal_control_for_tahoma_attr = $attributes;

$universal_control_for_tahoma_label = !empty($universal_control_for_tahoma_attr['universal_control_for_tahoma_customLabel'])
  ? $universal_control_for_tahoma_attr['universal_control_for_tahoma_customLabel']
  : ($universal_control_for_tahoma_attr['universal_control_for_tahoma_deviceLabel'] ?: __('TaHoma Device', 'universal-control-for-tahoma'));

$tahoma_config = [
  'deviceURL' => $universal_control_for_tahoma_attr['universal_control_for_tahoma_deviceURL'],
  'uiClass'   => $universal_control_for_tahoma_attr['universal_control_for_tahoma_uiClass'],
  'isToggle'  => (bool)$universal_control_for_tahoma_attr['universal_control_for_tahoma_isToggle'],
  'command'   => $universal_control_for_tahoma_attr['universal_control_for_tahoma_command'],
  'value'     => (int)$universal_control_for_tahoma_attr['universal_control_for_tahoma_value'],
  'nonce'     => wp_create_nonce('wp_rest'),
];
?>

<div
  <?php
  // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
  echo wp_kses_data(get_block_wrapper_attributes([
    'class' => 'universal-control-for-tahoma-block',
    'style' => sprintf(
      'background-color:%s; color:%s; width:%s; border:%dpx solid %s; border-radius:%dpx; padding:12px; cursor:pointer; text-align:center; transition: opacity 0.2s; font-size:%dpx;',
      esc_attr($universal_control_for_tahoma_attr['universal_control_for_tahoma_bgColor']),
      esc_attr($universal_control_for_tahoma_attr['universal_control_for_tahoma_textColor']),
      esc_attr($universal_control_for_tahoma_attr['universal_control_for_tahoma_width']),
      (int) $universal_control_for_tahoma_attr['universal_control_for_tahoma_borderWidth'],
      esc_attr($universal_control_for_tahoma_attr['universal_control_for_tahoma_borderColor']),
      (int) $universal_control_for_tahoma_attr['universal_control_for_tahoma_borderRadius'],
      (int) $universal_control_for_tahoma_attr['universal_control_for_tahoma_fontSize']
    ),
    'data-config' => wp_json_encode($tahoma_config),
  ]));
  ?>>
  <div class="tahoma-label" style="font-weight: bold;"><?php echo esc_html($universal_control_for_tahoma_label); ?></div>
  <div class="tahoma-status" style="font-size: 0.8em; opacity: 0.8; margin-top: 4px;">
    <?php esc_html_e('Loading...', 'universal-control-for-tahoma'); ?>
  </div>
</div>