<?php // phpcs:ignore - @generation-checksum US-66-19821
/**
 * Country Class for United States (US).
 *
 * State/province count: 66
 * City count: 19821
 * City count per state/province:
 * - TX: 1277 cities
 * - CA: 1123 cities
 * - PA: 1054 cities
 * - NY: 1054 cities
 * - IL: 855 cities
 * - FL: 845 cities
 * - OH: 756 cities
 * - NC: 554 cities
 * - NJ: 551 cities
 * - GA: 534 cities
 * - MI: 526 cities
 * - MO: 510 cities
 * - VA: 503 cities
 * - WI: 492 cities
 * - MN: 460 cities
 * - IN: 434 cities
 * - WA: 433 cities
 * - MA: 405 cities
 * - KY: 388 cities
 * - TN: 386 cities
 * - IA: 383 cities
 * - AL: 378 cities
 * - MD: 364 cities
 * - LA: 344 cities
 * - OK: 320 cities
 * - KS: 319 cities
 * - MS: 295 cities
 * - CO: 289 cities
 * - AR: 287 cities
 * - SC: 283 cities
 * - ME: 271 cities
 * - PR: 255 cities
 * - OR: 255 cities
 * - NE: 238 cities
 * - AZ: 227 cities
 * - WV: 217 cities
 * - UT: 207 cities
 * - CT: 191 cities
 * - NH: 186 cities
 * - NM: 182 cities
 * - SD: 167 cities
 * - MT: 161 cities
 * - ID: 142 cities
 * - ND: 133 cities
 * - HI: 121 cities
 * - VT: 96 cities
 * - AK: 95 cities
 * - NV: 82 cities
 * - WY: 80 cities
 * - RI: 54 cities
 * - DE: 54 cities
 * - DC: 5 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for United States (US).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_US extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'US',
		'currency'     => 'USD',
		'phone_code'   => 1,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'state';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('United States', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for US.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'AL'    => __('Alabama', 'ultimate-multisite'),
			'AK'    => __('Alaska', 'ultimate-multisite'),
			'AS'    => __('American Samoa', 'ultimate-multisite'),
			'AZ'    => __('Arizona', 'ultimate-multisite'),
			'AR'    => __('Arkansas', 'ultimate-multisite'),
			'UM-81' => __('Baker Island', 'ultimate-multisite'),
			'CA'    => __('California', 'ultimate-multisite'),
			'CO'    => __('Colorado', 'ultimate-multisite'),
			'CT'    => __('Connecticut', 'ultimate-multisite'),
			'DE'    => __('Delaware', 'ultimate-multisite'),
			'DC'    => __('District of Columbia', 'ultimate-multisite'),
			'FL'    => __('Florida', 'ultimate-multisite'),
			'GA'    => __('Georgia', 'ultimate-multisite'),
			'GU'    => __('Guam', 'ultimate-multisite'),
			'HI'    => __('Hawaii', 'ultimate-multisite'),
			'UM-84' => __('Howland Island', 'ultimate-multisite'),
			'ID'    => __('Idaho', 'ultimate-multisite'),
			'IL'    => __('Illinois', 'ultimate-multisite'),
			'IN'    => __('Indiana', 'ultimate-multisite'),
			'IA'    => __('Iowa', 'ultimate-multisite'),
			'UM-86' => __('Jarvis Island', 'ultimate-multisite'),
			'UM-67' => __('Johnston Atoll', 'ultimate-multisite'),
			'KS'    => __('Kansas', 'ultimate-multisite'),
			'KY'    => __('Kentucky', 'ultimate-multisite'),
			'UM-89' => __('Kingman Reef', 'ultimate-multisite'),
			'LA'    => __('Louisiana', 'ultimate-multisite'),
			'ME'    => __('Maine', 'ultimate-multisite'),
			'MD'    => __('Maryland', 'ultimate-multisite'),
			'MA'    => __('Massachusetts', 'ultimate-multisite'),
			'MI'    => __('Michigan', 'ultimate-multisite'),
			'UM-71' => __('Midway Atoll', 'ultimate-multisite'),
			'MN'    => __('Minnesota', 'ultimate-multisite'),
			'MS'    => __('Mississippi', 'ultimate-multisite'),
			'MO'    => __('Missouri', 'ultimate-multisite'),
			'MT'    => __('Montana', 'ultimate-multisite'),
			'UM-76' => __('Navassa Island', 'ultimate-multisite'),
			'NE'    => __('Nebraska', 'ultimate-multisite'),
			'NV'    => __('Nevada', 'ultimate-multisite'),
			'NH'    => __('New Hampshire', 'ultimate-multisite'),
			'NJ'    => __('New Jersey', 'ultimate-multisite'),
			'NM'    => __('New Mexico', 'ultimate-multisite'),
			'NY'    => __('New York', 'ultimate-multisite'),
			'NC'    => __('North Carolina', 'ultimate-multisite'),
			'ND'    => __('North Dakota', 'ultimate-multisite'),
			'MP'    => __('Northern Mariana Islands', 'ultimate-multisite'),
			'OH'    => __('Ohio', 'ultimate-multisite'),
			'OK'    => __('Oklahoma', 'ultimate-multisite'),
			'OR'    => __('Oregon', 'ultimate-multisite'),
			'UM-95' => __('Palmyra Atoll', 'ultimate-multisite'),
			'PA'    => __('Pennsylvania', 'ultimate-multisite'),
			'PR'    => __('Puerto Rico', 'ultimate-multisite'),
			'RI'    => __('Rhode Island', 'ultimate-multisite'),
			'SC'    => __('South Carolina', 'ultimate-multisite'),
			'SD'    => __('South Dakota', 'ultimate-multisite'),
			'TN'    => __('Tennessee', 'ultimate-multisite'),
			'TX'    => __('Texas', 'ultimate-multisite'),
			'UM'    => __('United States Minor Outlying Islands', 'ultimate-multisite'),
			'VI'    => __('United States Virgin Islands', 'ultimate-multisite'),
			'UT'    => __('Utah', 'ultimate-multisite'),
			'VT'    => __('Vermont', 'ultimate-multisite'),
			'VA'    => __('Virginia', 'ultimate-multisite'),
			'UM-79' => __('Wake Island', 'ultimate-multisite'),
			'WA'    => __('Washington', 'ultimate-multisite'),
			'WV'    => __('West Virginia', 'ultimate-multisite'),
			'WI'    => __('Wisconsin', 'ultimate-multisite'),
			'WY'    => __('Wyoming', 'ultimate-multisite'),
		];
	}
}
