<?php // phpcs:ignore - @generation-checksum TR-81-1347
/**
 * Country Class for Turkey (TR).
 *
 * State/province count: 81
 * City count: 1347
 * City count per state/province:
 * - 77: 12 cities
 * - 73: 38 cities
 * - 72: 23 cities
 * - 66: 15 cities
 * - 65: 15 cities
 * - 64: 12 cities
 * - 63: 31 cities
 * - 62: 11 cities
 * - 61: 19 cities
 * - 60: 12 cities
 * - 59: 16 cities
 * - 58: 19 cities
 * - 56: 22 cities
 * - 55: 18 cities
 * - 54: 17 cities
 * - 53: 11 cities
 * - 52: 21 cities
 * - 50: 10 cities
 * - 48: 26 cities
 * - 47: 64 cities
 * - 46: 14 cities
 * - 45: 19 cities
 * - 44: 14 cities
 * - 43: 13 cities
 * - 42: 38 cities
 * - 41: 25 cities
 * - 38: 18 cities
 * - 37: 20 cities
 * - 35: 43 cities
 * - 34: 40 cities
 * - 33: 18 cities
 * - 32: 15 cities
 * - 31: 40 cities
 * - 28: 17 cities
 * - 27: 15 cities
 * - 26: 18 cities
 * - 25: 22 cities
 * - 24: 10 cities
 * - 23: 13 cities
 * - 22: 10 cities
 * - 21: 28 cities
 * - 20: 24 cities
 * - 19: 15 cities
 * - 18: 12 cities
 * - 17: 18 cities
 * - 16: 39 cities
 * - 15: 14 cities
 * - 11: 11 cities
 * - 10: 21 cities
 * - 09: 25 cities
 * - 81: 8 cities
 * - 08: 10 cities
 * - 80: 7 cities
 * - 79: 4 cities
 * - 78: 7 cities
 * - 76: 3 cities
 * - 75: 6 cities
 * - 74: 4 cities
 * - 07: 37 cities
 * - 71: 9 cities
 * - 70: 7 cities
 * - 69: 4 cities
 * - 68: 9 cities
 * - 67: 8 cities
 * - 06: 30 cities
 * - 57: 9 cities
 * - 51: 6 cities
 * - 49: 7 cities
 * - 40: 7 cities
 * - 39: 9 cities
 * - 36: 8 cities
 * - 03: 20 cities
 * - 30: 6 cities
 * - 29: 9 cities
 * - 02: 11 cities
 * - 14: 9 cities
 * - 13: 9 cities
 * - 12: 9 cities
 * - 01: 17 cities
 * - 05: 9 cities
 * - 04: 8 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for Turkey (TR).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_TR extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'TR',
		'currency'     => 'TRY',
		'phone_code'   => 90,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'unknown';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('Turkey', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for TR.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'10' => __('Balıkesir', 'ultimate-multisite'),
			'11' => __('Bilecik', 'ultimate-multisite'),
			'12' => __('Bingöl', 'ultimate-multisite'),
			'13' => __('Bitlis', 'ultimate-multisite'),
			'14' => __('Bolu', 'ultimate-multisite'),
			'15' => __('Burdur', 'ultimate-multisite'),
			'16' => __('Bursa', 'ultimate-multisite'),
			'17' => __('Çanakkale', 'ultimate-multisite'),
			'18' => __('Çankırı', 'ultimate-multisite'),
			'19' => __('Çorum', 'ultimate-multisite'),
			'20' => __('Denizli', 'ultimate-multisite'),
			'21' => __('Diyarbakır', 'ultimate-multisite'),
			'22' => __('Edirne', 'ultimate-multisite'),
			'23' => __('Elazığ', 'ultimate-multisite'),
			'24' => __('Erzincan', 'ultimate-multisite'),
			'25' => __('Erzurum', 'ultimate-multisite'),
			'26' => __('Eskişehir', 'ultimate-multisite'),
			'27' => __('Gaziantep', 'ultimate-multisite'),
			'28' => __('Giresun', 'ultimate-multisite'),
			'29' => __('Gümüşhane', 'ultimate-multisite'),
			'30' => __('Hakkâri', 'ultimate-multisite'),
			'31' => __('Hatay', 'ultimate-multisite'),
			'32' => __('Isparta', 'ultimate-multisite'),
			'33' => __('Mersin', 'ultimate-multisite'),
			'34' => __('Istanbul', 'ultimate-multisite'),
			'35' => __('İzmir', 'ultimate-multisite'),
			'36' => __('Kars', 'ultimate-multisite'),
			'37' => __('Kastamonu', 'ultimate-multisite'),
			'38' => __('Kayseri', 'ultimate-multisite'),
			'39' => __('Kırklareli', 'ultimate-multisite'),
			'40' => __('Kırşehir', 'ultimate-multisite'),
			'41' => __('Kocaeli', 'ultimate-multisite'),
			'42' => __('Konya', 'ultimate-multisite'),
			'43' => __('Kütahya', 'ultimate-multisite'),
			'44' => __('Malatya', 'ultimate-multisite'),
			'45' => __('Manisa', 'ultimate-multisite'),
			'46' => __('Kahramanmaraş', 'ultimate-multisite'),
			'47' => __('Mardin', 'ultimate-multisite'),
			'48' => __('Muğla', 'ultimate-multisite'),
			'49' => __('Muş', 'ultimate-multisite'),
			'50' => __('Nevşehir', 'ultimate-multisite'),
			'51' => __('Niğde', 'ultimate-multisite'),
			'52' => __('Ordu', 'ultimate-multisite'),
			'53' => __('Rize', 'ultimate-multisite'),
			'54' => __('Sakarya', 'ultimate-multisite'),
			'55' => __('Samsun', 'ultimate-multisite'),
			'56' => __('Siirt', 'ultimate-multisite'),
			'57' => __('Sinop', 'ultimate-multisite'),
			'58' => __('Sivas', 'ultimate-multisite'),
			'59' => __('Tekirdağ', 'ultimate-multisite'),
			'60' => __('Tokat', 'ultimate-multisite'),
			'61' => __('Trabzon', 'ultimate-multisite'),
			'62' => __('Tunceli', 'ultimate-multisite'),
			'63' => __('Şanlıurfa', 'ultimate-multisite'),
			'64' => __('Uşak', 'ultimate-multisite'),
			'65' => __('Van', 'ultimate-multisite'),
			'66' => __('Yozgat', 'ultimate-multisite'),
			'67' => __('Zonguldak', 'ultimate-multisite'),
			'68' => __('Aksaray', 'ultimate-multisite'),
			'69' => __('Bayburt', 'ultimate-multisite'),
			'70' => __('Karaman', 'ultimate-multisite'),
			'71' => __('Kırıkkale', 'ultimate-multisite'),
			'72' => __('Batman', 'ultimate-multisite'),
			'73' => __('Şırnak', 'ultimate-multisite'),
			'74' => __('Bartın', 'ultimate-multisite'),
			'75' => __('Ardahan', 'ultimate-multisite'),
			'76' => __('Iğdır', 'ultimate-multisite'),
			'77' => __('Yalova', 'ultimate-multisite'),
			'78' => __('Karabük', 'ultimate-multisite'),
			'79' => __('Kilis', 'ultimate-multisite'),
			'80' => __('Osmaniye', 'ultimate-multisite'),
			'81' => __('Düzce', 'ultimate-multisite'),
			'01' => __('Adana', 'ultimate-multisite'),
			'02' => __('Adıyaman', 'ultimate-multisite'),
			'03' => __('Afyonkarahisar', 'ultimate-multisite'),
			'05' => __('Amasya', 'ultimate-multisite'),
			'06' => __('Ankara', 'ultimate-multisite'),
			'07' => __('Antalya', 'ultimate-multisite'),
			'08' => __('Artvin', 'ultimate-multisite'),
			'09' => __('Aydın', 'ultimate-multisite'),
			'04' => __('Ağrı', 'ultimate-multisite'),
		];
	}
}
