<?php // phpcs:ignore - @generation-checksum RU-84-5545
/**
 * Country Class for Russia (RU).
 *
 * State/province count: 84
 * City count: 5545
 * City count per state/province:
 * - UA-40: 147 cities
 * - MOS: 332 cities
 * - KDA: 229 cities
 * - DA: 175 cities
 * - ALT: 153 cities
 * - LEN: 141 cities
 * - SVE: 138 cities
 * - NIZ: 127 cities
 * - STA: 120 cities
 * - BA: 111 cities
 * - KYA: 109 cities
 * - ROS: 109 cities
 * - TA: 105 cities
 * - PRI: 96 cities
 * - CHE: 94 cities
 * - VOR: 92 cities
 * - MOW: 92 cities
 * - KIR: 89 cities
 * - TVE: 89 cities
 * - SA: 86 cities
 * - CE: 85 cities
 * - PER: 83 cities
 * - BRY: 83 cities
 * - VGG: 82 cities
 * - ZAB: 75 cities
 * - KEM: 72 cities
 * - SAR: 71 cities
 * - ARK: 71 cities
 * - KLU: 70 cities
 * - VLA: 66 cities
 * - BU: 66 cities
 * - TUL: 64 cities
 * - KB: 64 cities
 * - SAM: 64 cities
 * - VLG: 63 cities
 * - IVA: 61 cities
 * - NVS: 59 cities
 * - SPE: 58 cities
 * - AMU: 58 cities
 * - BEL: 56 cities
 * - NGR: 54 cities
 * - ORE: 52 cities
 * - YAR: 52 cities
 * - KO: 51 cities
 * - CU: 49 cities
 * - RYA: 48 cities
 * - MO: 48 cities
 * - KR: 48 cities
 * - PNZ: 47 cities
 * - LIP: 47 cities
 * - TYU: 46 cities
 * - ULY: 45 cities
 * - KHM: 44 cities
 * - KOS: 44 cities
 * - KRS: 44 cities
 * - PSK: 44 cities
 * - MUR: 42 cities
 * - SAK: 42 cities
 * - AST: 40 cities
 * - KHA: 40 cities
 * - OMS: 38 cities
 * - KGD: 37 cities
 * - UD: 36 cities
 * - SMO: 36 cities
 * - TAM: 35 cities
 * - ME: 35 cities
 * - KC: 34 cities
 * - SE: 31 cities
 * - KGN: 31 cities
 * - AD: 30 cities
 * - TOM: 30 cities
 * - ORL: 27 cities
 * - KAM: 26 cities
 * - AL: 25 cities
 * - IN: 25 cities
 * - YAN: 24 cities
 * - KK: 22 cities
 * - MAG: 22 cities
 * - TY: 21 cities
 * - YEV: 18 cities
 * - KL: 18 cities
 * - CHU: 10 cities
 * - NEN: 2 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for Russia (RU).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_RU extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'RU',
		'currency'     => 'RUB',
		'phone_code'   => 7,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'unknown';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('Russia', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for RU.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'ALT'   => __('Altai Krai', 'ultimate-multisite'),
			'AL'    => __('Altai Republic', 'ultimate-multisite'),
			'AMU'   => __('Amur Oblast', 'ultimate-multisite'),
			'ARK'   => __('Arkhangelsk', 'ultimate-multisite'),
			'AST'   => __('Astrakhan Oblast', 'ultimate-multisite'),
			'BEL'   => __('Belgorod Oblast', 'ultimate-multisite'),
			'BRY'   => __('Bryansk Oblast', 'ultimate-multisite'),
			'CE'    => __('Chechen Republic', 'ultimate-multisite'),
			'CHE'   => __('Chelyabinsk Oblast', 'ultimate-multisite'),
			'CHU'   => __('Chukotka Autonomous Okrug', 'ultimate-multisite'),
			'CU'    => __('Chuvash Republic', 'ultimate-multisite'),
			'IRK'   => __('Irkutsk', 'ultimate-multisite'),
			'IVA'   => __('Ivanovo Oblast', 'ultimate-multisite'),
			'YEV'   => __('Jewish Autonomous Oblast', 'ultimate-multisite'),
			'KB'    => __('Kabardino-Balkar Republic', 'ultimate-multisite'),
			'KGD'   => __('Kaliningrad', 'ultimate-multisite'),
			'KLU'   => __('Kaluga Oblast', 'ultimate-multisite'),
			'KAM'   => __('Kamchatka Krai', 'ultimate-multisite'),
			'KC'    => __('Karachay-Cherkess Republic', 'ultimate-multisite'),
			'KEM'   => __('Kemerovo Oblast', 'ultimate-multisite'),
			'KHA'   => __('Khabarovsk Krai', 'ultimate-multisite'),
			'KHM'   => __('Khanty-Mansi Autonomous Okrug', 'ultimate-multisite'),
			'KIR'   => __('Kirov Oblast', 'ultimate-multisite'),
			'KO'    => __('Komi Republic', 'ultimate-multisite'),
			'KOS'   => __('Kostroma Oblast', 'ultimate-multisite'),
			'KDA'   => __('Krasnodar Krai', 'ultimate-multisite'),
			'KYA'   => __('Krasnoyarsk Krai', 'ultimate-multisite'),
			'KGN'   => __('Kurgan Oblast', 'ultimate-multisite'),
			'KRS'   => __('Kursk Oblast', 'ultimate-multisite'),
			'LEN'   => __('Leningrad Oblast', 'ultimate-multisite'),
			'LIP'   => __('Lipetsk Oblast', 'ultimate-multisite'),
			'MAG'   => __('Magadan Oblast', 'ultimate-multisite'),
			'ME'    => __('Mari El Republic', 'ultimate-multisite'),
			'MOW'   => __('Moscow', 'ultimate-multisite'),
			'MOS'   => __('Moscow Oblast', 'ultimate-multisite'),
			'MUR'   => __('Murmansk Oblast', 'ultimate-multisite'),
			'NEN'   => __('Nenets Autonomous Okrug', 'ultimate-multisite'),
			'NIZ'   => __('Nizhny Novgorod Oblast', 'ultimate-multisite'),
			'NGR'   => __('Novgorod Oblast', 'ultimate-multisite'),
			'NVS'   => __('Novosibirsk', 'ultimate-multisite'),
			'OMS'   => __('Omsk Oblast', 'ultimate-multisite'),
			'ORE'   => __('Orenburg Oblast', 'ultimate-multisite'),
			'ORL'   => __('Oryol Oblast', 'ultimate-multisite'),
			'PNZ'   => __('Penza Oblast', 'ultimate-multisite'),
			'PER'   => __('Perm Krai', 'ultimate-multisite'),
			'PRI'   => __('Primorsky Krai', 'ultimate-multisite'),
			'PSK'   => __('Pskov Oblast', 'ultimate-multisite'),
			'AD'    => __('Republic of Adygea', 'ultimate-multisite'),
			'BA'    => __('Republic of Bashkortostan', 'ultimate-multisite'),
			'BU'    => __('Republic of Buryatia', 'ultimate-multisite'),
			'DA'    => __('Republic of Dagestan', 'ultimate-multisite'),
			'IN'    => __('Republic of Ingushetia', 'ultimate-multisite'),
			'KL'    => __('Republic of Kalmykia', 'ultimate-multisite'),
			'KR'    => __('Republic of Karelia', 'ultimate-multisite'),
			'KK'    => __('Republic of Khakassia', 'ultimate-multisite'),
			'MO'    => __('Republic of Mordovia', 'ultimate-multisite'),
			'SE'    => __('Republic of North Ossetia-Alania', 'ultimate-multisite'),
			'TA'    => __('Republic of Tatarstan', 'ultimate-multisite'),
			'ROS'   => __('Rostov Oblast', 'ultimate-multisite'),
			'RYA'   => __('Ryazan Oblast', 'ultimate-multisite'),
			'SPE'   => __('Saint Petersburg', 'ultimate-multisite'),
			'SA'    => __('Sakha Republic', 'ultimate-multisite'),
			'SAK'   => __('Sakhalin', 'ultimate-multisite'),
			'SAM'   => __('Samara Oblast', 'ultimate-multisite'),
			'SAR'   => __('Saratov Oblast', 'ultimate-multisite'),
			'UA-40' => __('Sevastopol', 'ultimate-multisite'),
			'SMO'   => __('Smolensk Oblast', 'ultimate-multisite'),
			'STA'   => __('Stavropol Krai', 'ultimate-multisite'),
			'SVE'   => __('Sverdlovsk', 'ultimate-multisite'),
			'TAM'   => __('Tambov Oblast', 'ultimate-multisite'),
			'TOM'   => __('Tomsk Oblast', 'ultimate-multisite'),
			'TUL'   => __('Tula Oblast', 'ultimate-multisite'),
			'TY'    => __('Tuva Republic', 'ultimate-multisite'),
			'TVE'   => __('Tver Oblast', 'ultimate-multisite'),
			'TYU'   => __('Tyumen Oblast', 'ultimate-multisite'),
			'UD'    => __('Udmurt Republic', 'ultimate-multisite'),
			'ULY'   => __('Ulyanovsk Oblast', 'ultimate-multisite'),
			'VLA'   => __('Vladimir Oblast', 'ultimate-multisite'),
			'VGG'   => __('Volgograd Oblast', 'ultimate-multisite'),
			'VLG'   => __('Vologda Oblast', 'ultimate-multisite'),
			'VOR'   => __('Voronezh Oblast', 'ultimate-multisite'),
			'YAN'   => __('Yamalo-Nenets Autonomous Okrug', 'ultimate-multisite'),
			'YAR'   => __('Yaroslavl Oblast', 'ultimate-multisite'),
			'ZAB'   => __('Zabaykalsky Krai', 'ultimate-multisite'),
		];
	}
}
