<?php // phpcs:ignore - @generation-checksum NL-15-1740
/**
 * Country Class for Netherlands (NL).
 *
 * State/province count: 15
 * City count: 1740
 * City count per state/province:
 * - NB: 317 cities
 * - GE: 271 cities
 * - ZH: 224 cities
 * - LI: 205 cities
 * - NH: 172 cities
 * - FR: 132 cities
 * - OV: 90 cities
 * - UT: 86 cities
 * - GR: 79 cities
 * - DR: 76 cities
 * - ZE: 74 cities
 * - FL: 14 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for Netherlands (NL).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_NL extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'NL',
		'currency'     => 'EUR',
		'phone_code'   => 31,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'province';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('Netherlands', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for NL.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'BQ1' => __('Bonaire', 'ultimate-multisite'),
			'DR'  => __('Drenthe', 'ultimate-multisite'),
			'FL'  => __('Flevoland', 'ultimate-multisite'),
			'FR'  => __('Friesland', 'ultimate-multisite'),
			'GE'  => __('Gelderland', 'ultimate-multisite'),
			'GR'  => __('Groningen', 'ultimate-multisite'),
			'LI'  => __('Limburg', 'ultimate-multisite'),
			'NB'  => __('North Brabant', 'ultimate-multisite'),
			'NH'  => __('North Holland', 'ultimate-multisite'),
			'OV'  => __('Overijssel', 'ultimate-multisite'),
			'BQ2' => __('Saba', 'ultimate-multisite'),
			'BQ3' => __('Sint Eustatius', 'ultimate-multisite'),
			'ZH'  => __('South Holland', 'ultimate-multisite'),
			'UT'  => __('Utrecht', 'ultimate-multisite'),
			'ZE'  => __('Zeeland', 'ultimate-multisite'),
		];
	}
}
