<?php // phpcs:ignore - @generation-checksum MX-32-9174
/**
 * Country Class for Mexico (MX).
 *
 * State/province count: 32
 * City count: 9174
 * City count per state/province:
 * - MEX: 940 cities
 * - JAL: 821 cities
 * - VER: 764 cities
 * - PUE: 761 cities
 * - OAX: 694 cities
 * - CHP: 534 cities
 * - GUA: 476 cities
 * - MIC: 442 cities
 * - GRO: 433 cities
 * - HID: 417 cities
 * - MOR: 253 cities
 * - SIN: 221 cities
 * - TAB: 214 cities
 * - QUE: 202 cities
 * - YUC: 200 cities
 * - SLP: 177 cities
 * - ZAC: 175 cities
 * - SON: 160 cities
 * - TLA: 154 cities
 * - CHH: 148 cities
 * - DUR: 132 cities
 * - NAY: 118 cities
 * - COA: 111 cities
 * - TAM: 110 cities
 * - BCN: 95 cities
 * - NLE: 92 cities
 * - AGU: 91 cities
 * - CAM: 73 cities
 * - ROO: 64 cities
 * - CDMX: 38 cities
 * - COL: 33 cities
 * - BCS: 31 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for Mexico (MX).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_MX extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'MX',
		'currency'     => 'MXN',
		'phone_code'   => 52,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'unknown';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('Mexico', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for MX.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'AGU'  => __('Aguascalientes', 'ultimate-multisite'),
			'BCN'  => __('Baja California', 'ultimate-multisite'),
			'BCS'  => __('Baja California Sur', 'ultimate-multisite'),
			'CAM'  => __('Campeche', 'ultimate-multisite'),
			'CHP'  => __('Chiapas', 'ultimate-multisite'),
			'CHH'  => __('Chihuahua', 'ultimate-multisite'),
			'CDMX' => __('Ciudad de México', 'ultimate-multisite'),
			'COA'  => __('Coahuila de Zaragoza', 'ultimate-multisite'),
			'COL'  => __('Colima', 'ultimate-multisite'),
			'DUR'  => __('Durango', 'ultimate-multisite'),
			'MEX'  => __('Estado de México', 'ultimate-multisite'),
			'GUA'  => __('Guanajuato', 'ultimate-multisite'),
			'GRO'  => __('Guerrero', 'ultimate-multisite'),
			'HID'  => __('Hidalgo', 'ultimate-multisite'),
			'JAL'  => __('Jalisco', 'ultimate-multisite'),
			'MIC'  => __('Michoacán de Ocampo', 'ultimate-multisite'),
			'MOR'  => __('Morelos', 'ultimate-multisite'),
			'NAY'  => __('Nayarit', 'ultimate-multisite'),
			'NLE'  => __('Nuevo León', 'ultimate-multisite'),
			'OAX'  => __('Oaxaca', 'ultimate-multisite'),
			'PUE'  => __('Puebla', 'ultimate-multisite'),
			'QUE'  => __('Querétaro', 'ultimate-multisite'),
			'ROO'  => __('Quintana Roo', 'ultimate-multisite'),
			'SLP'  => __('San Luis Potosí', 'ultimate-multisite'),
			'SIN'  => __('Sinaloa', 'ultimate-multisite'),
			'SON'  => __('Sonora', 'ultimate-multisite'),
			'TAB'  => __('Tabasco', 'ultimate-multisite'),
			'TAM'  => __('Tamaulipas', 'ultimate-multisite'),
			'TLA'  => __('Tlaxcala', 'ultimate-multisite'),
			'VER'  => __('Veracruz de Ignacio de la Llave', 'ultimate-multisite'),
			'YUC'  => __('Yucatán', 'ultimate-multisite'),
			'ZAC'  => __('Zacatecas', 'ultimate-multisite'),
		];
	}
}
