<?php // phpcs:ignore - @generation-checksum JP-47-1671
/**
 * Country Class for Japan (JP).
 *
 * State/province count: 47
 * City count: 1671
 * City count per state/province:
 * - 39: 110 cities
 * - 47: 25 cities
 * - 46: 46 cities
 * - 45: 17 cities
 * - 44: 26 cities
 * - 43: 27 cities
 * - 42: 22 cities
 * - 41: 16 cities
 * - 40: 56 cities
 * - 38: 20 cities
 * - 37: 15 cities
 * - 36: 17 cities
 * - 35: 21 cities
 * - 34: 30 cities
 * - 33: 25 cities
 * - 32: 16 cities
 * - 30: 16 cities
 * - 29: 21 cities
 * - 28: 53 cities
 * - 27: 57 cities
 * - 26: 24 cities
 * - 25: 24 cities
 * - 24: 28 cities
 * - 23: 70 cities
 * - 22: 44 cities
 * - 21: 35 cities
 * - 20: 40 cities
 * - 19: 23 cities
 * - 18: 19 cities
 * - 17: 18 cities
 * - 16: 21 cities
 * - 15: 46 cities
 * - 14: 40 cities
 * - 13: 63 cities
 * - 12: 65 cities
 * - 11: 83 cities
 * - 10: 31 cities
 * - 09: 33 cities
 * - 08: 72 cities
 * - 07: 30 cities
 * - 06: 27 cities
 * - 05: 27 cities
 * - 04: 33 cities
 * - 03: 32 cities
 * - 31: 5 cities
 * - 02: 21 cities
 * - 01: 81 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for Japan (JP).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_JP extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'JP',
		'currency'     => 'JPY',
		'phone_code'   => 81,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'prefecture';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('Japan', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for JP.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'10' => __('Gunma Prefecture', 'ultimate-multisite'),
			'11' => __('Saitama Prefecture', 'ultimate-multisite'),
			'12' => __('Chiba Prefecture', 'ultimate-multisite'),
			'13' => __('Tokyo', 'ultimate-multisite'),
			'14' => __('Kanagawa Prefecture', 'ultimate-multisite'),
			'15' => __('Niigata Prefecture', 'ultimate-multisite'),
			'16' => __('Toyama Prefecture', 'ultimate-multisite'),
			'17' => __('Ishikawa Prefecture', 'ultimate-multisite'),
			'18' => __('Fukui Prefecture', 'ultimate-multisite'),
			'19' => __('Yamanashi Prefecture', 'ultimate-multisite'),
			'20' => __('Nagano Prefecture', 'ultimate-multisite'),
			'21' => __('Gifu Prefecture', 'ultimate-multisite'),
			'22' => __('Shizuoka Prefecture', 'ultimate-multisite'),
			'23' => __('Aichi Prefecture', 'ultimate-multisite'),
			'24' => __('Mie Prefecture', 'ultimate-multisite'),
			'25' => __('Shiga Prefecture', 'ultimate-multisite'),
			'26' => __('Kyōto Prefecture', 'ultimate-multisite'),
			'27' => __('Ōsaka Prefecture', 'ultimate-multisite'),
			'28' => __('Hyōgo Prefecture', 'ultimate-multisite'),
			'29' => __('Nara Prefecture', 'ultimate-multisite'),
			'30' => __('Wakayama Prefecture', 'ultimate-multisite'),
			'31' => __('Tottori Prefecture', 'ultimate-multisite'),
			'32' => __('Shimane Prefecture', 'ultimate-multisite'),
			'33' => __('Okayama Prefecture', 'ultimate-multisite'),
			'34' => __('Hiroshima Prefecture', 'ultimate-multisite'),
			'35' => __('Yamaguchi Prefecture', 'ultimate-multisite'),
			'36' => __('Tokushima Prefecture', 'ultimate-multisite'),
			'37' => __('Kagawa Prefecture', 'ultimate-multisite'),
			'38' => __('Ehime Prefecture', 'ultimate-multisite'),
			'39' => __('Kōchi Prefecture', 'ultimate-multisite'),
			'40' => __('Fukuoka Prefecture', 'ultimate-multisite'),
			'41' => __('Saga Prefecture', 'ultimate-multisite'),
			'42' => __('Nagasaki Prefecture', 'ultimate-multisite'),
			'43' => __('Kumamoto Prefecture', 'ultimate-multisite'),
			'44' => __('Ōita Prefecture', 'ultimate-multisite'),
			'45' => __('Miyazaki Prefecture', 'ultimate-multisite'),
			'46' => __('Kagoshima Prefecture', 'ultimate-multisite'),
			'47' => __('Okinawa Prefecture', 'ultimate-multisite'),
			'05' => __('Akita Prefecture', 'ultimate-multisite'),
			'02' => __('Aomori Prefecture', 'ultimate-multisite'),
			'07' => __('Fukushima Prefecture', 'ultimate-multisite'),
			'01' => __('Hokkaidō Prefecture', 'ultimate-multisite'),
			'08' => __('Ibaraki Prefecture', 'ultimate-multisite'),
			'03' => __('Iwate Prefecture', 'ultimate-multisite'),
			'04' => __('Miyagi Prefecture', 'ultimate-multisite'),
			'09' => __('Tochigi Prefecture', 'ultimate-multisite'),
			'06' => __('Yamagata Prefecture', 'ultimate-multisite'),
		];
	}
}
