<?php // phpcs:ignore - @generation-checksum IN-36-4242
/**
 * Country Class for India (IN).
 *
 * State/province count: 36
 * City count: 4242
 * City count per state/province:
 * - UP: 624 cities
 * - MH: 574 cities
 * - TN: 350 cities
 * - GJ: 311 cities
 * - MP: 275 cities
 * - WB: 260 cities
 * - KA: 242 cities
 * - RJ: 187 cities
 * - AP: 168 cities
 * - BR: 132 cities
 * - PB: 115 cities
 * - OR: 113 cities
 * - KL: 107 cities
 * - TG: 89 cities
 * - AS: 87 cities
 * - HR: 83 cities
 * - CT: 78 cities
 * - JH: 77 cities
 * - HP: 57 cities
 * - JK: 56 cities
 * - UT: 55 cities
 * - GA: 50 cities
 * - AR: 26 cities
 * - TR: 19 cities
 * - DL: 19 cities
 * - ML: 18 cities
 * - MZ: 15 cities
 * - MN: 13 cities
 * - SK: 12 cities
 * - NL: 10 cities
 * - DH: 7 cities
 * - AN: 4 cities
 * - PY: 4 cities
 * - LA: 2 cities
 * - LD: 2 cities
 * - CH: 1 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for India (IN).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_IN extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'IN',
		'currency'     => 'INR',
		'phone_code'   => 91,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'unknown';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('India', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for IN.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'AN' => __('Andaman and Nicobar Islands', 'ultimate-multisite'),
			'AP' => __('Andhra Pradesh', 'ultimate-multisite'),
			'AR' => __('Arunachal Pradesh', 'ultimate-multisite'),
			'AS' => __('Assam', 'ultimate-multisite'),
			'BR' => __('Bihar', 'ultimate-multisite'),
			'CH' => __('Chandigarh', 'ultimate-multisite'),
			'CT' => __('Chhattisgarh', 'ultimate-multisite'),
			'DH' => __('Dadra and Nagar Haveli and Daman and Diu', 'ultimate-multisite'),
			'DL' => __('Delhi', 'ultimate-multisite'),
			'GA' => __('Goa', 'ultimate-multisite'),
			'GJ' => __('Gujarat', 'ultimate-multisite'),
			'HR' => __('Haryana', 'ultimate-multisite'),
			'HP' => __('Himachal Pradesh', 'ultimate-multisite'),
			'JK' => __('Jammu and Kashmir', 'ultimate-multisite'),
			'JH' => __('Jharkhand', 'ultimate-multisite'),
			'KA' => __('Karnataka', 'ultimate-multisite'),
			'KL' => __('Kerala', 'ultimate-multisite'),
			'LA' => __('Ladakh', 'ultimate-multisite'),
			'LD' => __('Lakshadweep', 'ultimate-multisite'),
			'MP' => __('Madhya Pradesh', 'ultimate-multisite'),
			'MH' => __('Maharashtra', 'ultimate-multisite'),
			'MN' => __('Manipur', 'ultimate-multisite'),
			'ML' => __('Meghalaya', 'ultimate-multisite'),
			'MZ' => __('Mizoram', 'ultimate-multisite'),
			'NL' => __('Nagaland', 'ultimate-multisite'),
			'OR' => __('Odisha', 'ultimate-multisite'),
			'PY' => __('Puducherry', 'ultimate-multisite'),
			'PB' => __('Punjab', 'ultimate-multisite'),
			'RJ' => __('Rajasthan', 'ultimate-multisite'),
			'SK' => __('Sikkim', 'ultimate-multisite'),
			'TN' => __('Tamil Nadu', 'ultimate-multisite'),
			'TG' => __('Telangana', 'ultimate-multisite'),
			'TR' => __('Tripura', 'ultimate-multisite'),
			'UP' => __('Uttar Pradesh', 'ultimate-multisite'),
			'UT' => __('Uttarakhand', 'ultimate-multisite'),
			'WB' => __('West Bengal', 'ultimate-multisite'),
		];
	}
}
