<?php // phpcs:ignore - @generation-checksum GB-247-3871
/**
 * Country Class for United Kingdom (GB).
 *
 * State/province count: 247
 * City count: 3871
 * City count per state/province:
 * - ENG: 2919 cities
 * - SCT: 530 cities
 * - WLS: 302 cities
 * - NYK: 120 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for United Kingdom (GB).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_GB extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'GB',
		'currency'     => 'GBP',
		'phone_code'   => 44,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'unknown';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('United Kingdom', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for GB.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'ABE'   => __('Aberdeen', 'ultimate-multisite'),
			'ABD'   => __('Aberdeenshire', 'ultimate-multisite'),
			'ANS'   => __('Angus', 'ultimate-multisite'),
			'ANT'   => __('Antrim', 'ultimate-multisite'),
			'ANN'   => __('Antrim and Newtownabbey', 'ultimate-multisite'),
			'ARD'   => __('Ards', 'ultimate-multisite'),
			'AND'   => __('Ards and North Down', 'ultimate-multisite'),
			'AGB'   => __('Argyll and Bute', 'ultimate-multisite'),
			'ARM'   => __('Armagh City and District Council', 'ultimate-multisite'),
			'ABC'   => __('Armagh, Banbridge and Craigavon', 'ultimate-multisite'),
			'SH-AC' => __('Ascension Island', 'ultimate-multisite'),
			'BLA'   => __('Ballymena Borough', 'ultimate-multisite'),
			'BLY'   => __('Ballymoney', 'ultimate-multisite'),
			'BNB'   => __('Banbridge', 'ultimate-multisite'),
			'BNS'   => __('Barnsley', 'ultimate-multisite'),
			'BAS'   => __('Bath and North East Somerset', 'ultimate-multisite'),
			'BDF'   => __('Bedford', 'ultimate-multisite'),
			'BFS'   => __('Belfast district', 'ultimate-multisite'),
			'BIR'   => __('Birmingham', 'ultimate-multisite'),
			'BBD'   => __('Blackburn with Darwen', 'ultimate-multisite'),
			'BPL'   => __('Blackpool', 'ultimate-multisite'),
			'BGW'   => __('Blaenau Gwent County Borough', 'ultimate-multisite'),
			'BOL'   => __('Bolton', 'ultimate-multisite'),
			'BMH'   => __('Bournemouth', 'ultimate-multisite'),
			'BRC'   => __('Bracknell Forest', 'ultimate-multisite'),
			'BRD'   => __('Bradford', 'ultimate-multisite'),
			'BGE'   => __('Bridgend County Borough', 'ultimate-multisite'),
			'BNH'   => __('Brighton and Hove', 'ultimate-multisite'),
			'BKM'   => __('Buckinghamshire', 'ultimate-multisite'),
			'BUR'   => __('Bury', 'ultimate-multisite'),
			'CAY'   => __('Caerphilly County Borough', 'ultimate-multisite'),
			'CLD'   => __('Calderdale', 'ultimate-multisite'),
			'CAM'   => __('Cambridgeshire', 'ultimate-multisite'),
			'CMN'   => __('Carmarthenshire', 'ultimate-multisite'),
			'CKF'   => __('Carrickfergus Borough Council', 'ultimate-multisite'),
			'CSR'   => __('Castlereagh', 'ultimate-multisite'),
			'CCG'   => __('Causeway Coast and Glens', 'ultimate-multisite'),
			'CBF'   => __('Central Bedfordshire', 'ultimate-multisite'),
			'CGN'   => __('Ceredigion', 'ultimate-multisite'),
			'CHE'   => __('Cheshire East', 'ultimate-multisite'),
			'CHW'   => __('Cheshire West and Chester', 'ultimate-multisite'),
			'CRF'   => __('City and County of Cardiff', 'ultimate-multisite'),
			'SWA'   => __('City and County of Swansea', 'ultimate-multisite'),
			'BST'   => __('City of Bristol', 'ultimate-multisite'),
			'DER'   => __('City of Derby', 'ultimate-multisite'),
			'KHL'   => __('City of Kingston upon Hull', 'ultimate-multisite'),
			'LCE'   => __('City of Leicester', 'ultimate-multisite'),
			'LND'   => __('City of London', 'ultimate-multisite'),
			'NGM'   => __('City of Nottingham', 'ultimate-multisite'),
			'PTE'   => __('City of Peterborough', 'ultimate-multisite'),
			'PLY'   => __('City of Plymouth', 'ultimate-multisite'),
			'POR'   => __('City of Portsmouth', 'ultimate-multisite'),
			'STH'   => __('City of Southampton', 'ultimate-multisite'),
			'STE'   => __('City of Stoke-on-Trent', 'ultimate-multisite'),
			'SND'   => __('City of Sunderland', 'ultimate-multisite'),
			'WSM'   => __('City of Westminster', 'ultimate-multisite'),
			'WLV'   => __('City of Wolverhampton', 'ultimate-multisite'),
			'YOR'   => __('City of York', 'ultimate-multisite'),
			'CLK'   => __('Clackmannanshire', 'ultimate-multisite'),
			'CLR'   => __('Coleraine Borough Council', 'ultimate-multisite'),
			'CWY'   => __('Conwy County Borough', 'ultimate-multisite'),
			'CKT'   => __('Cookstown District Council', 'ultimate-multisite'),
			'CON'   => __('Cornwall', 'ultimate-multisite'),
			'DUR'   => __('County Durham', 'ultimate-multisite'),
			'COV'   => __('Coventry', 'ultimate-multisite'),
			'CGV'   => __('Craigavon Borough Council', 'ultimate-multisite'),
			'CMA'   => __('Cumbria', 'ultimate-multisite'),
			'DAL'   => __('Darlington', 'ultimate-multisite'),
			'DEN'   => __('Denbighshire', 'ultimate-multisite'),
			'DBY'   => __('Derbyshire', 'ultimate-multisite'),
			'DRY'   => __('Derry City Council', 'ultimate-multisite'),
			'DRS'   => __('Derry City and Strabane', 'ultimate-multisite'),
			'DEV'   => __('Devon', 'ultimate-multisite'),
			'DNC'   => __('Doncaster', 'ultimate-multisite'),
			'DOR'   => __('Dorset', 'ultimate-multisite'),
			'DOW'   => __('Down District Council', 'ultimate-multisite'),
			'DUD'   => __('Dudley', 'ultimate-multisite'),
			'DGY'   => __('Dumfries and Galloway', 'ultimate-multisite'),
			'DND'   => __('Dundee', 'ultimate-multisite'),
			'DGN'   => __('Dungannon and South Tyrone Borough Council', 'ultimate-multisite'),
			'EAY'   => __('East Ayrshire', 'ultimate-multisite'),
			'EDU'   => __('East Dunbartonshire', 'ultimate-multisite'),
			'ELN'   => __('East Lothian', 'ultimate-multisite'),
			'ERW'   => __('East Renfrewshire', 'ultimate-multisite'),
			'ERY'   => __('East Riding of Yorkshire', 'ultimate-multisite'),
			'ESX'   => __('East Sussex', 'ultimate-multisite'),
			'EDH'   => __('Edinburgh', 'ultimate-multisite'),
			'ENG'   => __('England', 'ultimate-multisite'),
			'ESS'   => __('Essex', 'ultimate-multisite'),
			'FAL'   => __('Falkirk', 'ultimate-multisite'),
			'FER'   => __('Fermanagh District Council', 'ultimate-multisite'),
			'FMO'   => __('Fermanagh and Omagh', 'ultimate-multisite'),
			'FIF'   => __('Fife', 'ultimate-multisite'),
			'FLN'   => __('Flintshire', 'ultimate-multisite'),
			'GAT'   => __('Gateshead', 'ultimate-multisite'),
			'GLG'   => __('Glasgow', 'ultimate-multisite'),
			'GLS'   => __('Gloucestershire', 'ultimate-multisite'),
			'GWN'   => __('Gwynedd', 'ultimate-multisite'),
			'HAL'   => __('Halton', 'ultimate-multisite'),
			'HAM'   => __('Hampshire', 'ultimate-multisite'),
			'HPL'   => __('Hartlepool', 'ultimate-multisite'),
			'HEF'   => __('Herefordshire', 'ultimate-multisite'),
			'HRT'   => __('Hertfordshire', 'ultimate-multisite'),
			'HLD'   => __('Highland', 'ultimate-multisite'),
			'IVC'   => __('Inverclyde', 'ultimate-multisite'),
			'IOW'   => __('Isle of Wight', 'ultimate-multisite'),
			'IOS'   => __('Isles of Scilly', 'ultimate-multisite'),
			'KEN'   => __('Kent', 'ultimate-multisite'),
			'KIR'   => __('Kirklees', 'ultimate-multisite'),
			'KWL'   => __('Knowsley', 'ultimate-multisite'),
			'LAN'   => __('Lancashire', 'ultimate-multisite'),
			'LRN'   => __('Larne Borough Council', 'ultimate-multisite'),
			'LDS'   => __('Leeds', 'ultimate-multisite'),
			'LEC'   => __('Leicestershire', 'ultimate-multisite'),
			'LMV'   => __('Limavady Borough Council', 'ultimate-multisite'),
			'LIN'   => __('Lincolnshire', 'ultimate-multisite'),
			'LSB'   => __('Lisburn City Council', 'ultimate-multisite'),
			'LBC'   => __('Lisburn and Castlereagh', 'ultimate-multisite'),
			'LIV'   => __('Liverpool', 'ultimate-multisite'),
			'BDG'   => __('London Borough of Barking and Dagenham', 'ultimate-multisite'),
			'BNE'   => __('London Borough of Barnet', 'ultimate-multisite'),
			'BEX'   => __('London Borough of Bexley', 'ultimate-multisite'),
			'BEN'   => __('London Borough of Brent', 'ultimate-multisite'),
			'BRY'   => __('London Borough of Bromley', 'ultimate-multisite'),
			'CMD'   => __('London Borough of Camden', 'ultimate-multisite'),
			'CRY'   => __('London Borough of Croydon', 'ultimate-multisite'),
			'EAL'   => __('London Borough of Ealing', 'ultimate-multisite'),
			'ENF'   => __('London Borough of Enfield', 'ultimate-multisite'),
			'HCK'   => __('London Borough of Hackney', 'ultimate-multisite'),
			'HMF'   => __('London Borough of Hammersmith and Fulham', 'ultimate-multisite'),
			'HRY'   => __('London Borough of Haringey', 'ultimate-multisite'),
			'HRW'   => __('London Borough of Harrow', 'ultimate-multisite'),
			'HAV'   => __('London Borough of Havering', 'ultimate-multisite'),
			'HIL'   => __('London Borough of Hillingdon', 'ultimate-multisite'),
			'HNS'   => __('London Borough of Hounslow', 'ultimate-multisite'),
			'ISL'   => __('London Borough of Islington', 'ultimate-multisite'),
			'LBH'   => __('London Borough of Lambeth', 'ultimate-multisite'),
			'LEW'   => __('London Borough of Lewisham', 'ultimate-multisite'),
			'MRT'   => __('London Borough of Merton', 'ultimate-multisite'),
			'NWM'   => __('London Borough of Newham', 'ultimate-multisite'),
			'RDB'   => __('London Borough of Redbridge', 'ultimate-multisite'),
			'RIC'   => __('London Borough of Richmond upon Thames', 'ultimate-multisite'),
			'SWK'   => __('London Borough of Southwark', 'ultimate-multisite'),
			'STN'   => __('London Borough of Sutton', 'ultimate-multisite'),
			'TWH'   => __('London Borough of Tower Hamlets', 'ultimate-multisite'),
			'WFT'   => __('London Borough of Waltham Forest', 'ultimate-multisite'),
			'WND'   => __('London Borough of Wandsworth', 'ultimate-multisite'),
			'MFT'   => __('Magherafelt District Council', 'ultimate-multisite'),
			'MAN'   => __('Manchester', 'ultimate-multisite'),
			'MDW'   => __('Medway', 'ultimate-multisite'),
			'MTY'   => __('Merthyr Tydfil County Borough', 'ultimate-multisite'),
			'WGN'   => __('Metropolitan Borough of Wigan', 'ultimate-multisite'),
			'MUL'   => __('Mid Ulster', 'ultimate-multisite'),
			'MEA'   => __('Mid and East Antrim', 'ultimate-multisite'),
			'MDB'   => __('Middlesbrough', 'ultimate-multisite'),
			'MLN'   => __('Midlothian', 'ultimate-multisite'),
			'MIK'   => __('Milton Keynes', 'ultimate-multisite'),
			'MON'   => __('Monmouthshire', 'ultimate-multisite'),
			'MRY'   => __('Moray', 'ultimate-multisite'),
			'MYL'   => __('Moyle District Council', 'ultimate-multisite'),
			'NTL'   => __('Neath Port Talbot County Borough', 'ultimate-multisite'),
			'NET'   => __('Newcastle upon Tyne', 'ultimate-multisite'),
			'NWP'   => __('Newport', 'ultimate-multisite'),
			'NYM'   => __('Newry and Mourne District Council', 'ultimate-multisite'),
			'NMD'   => __('Newry, Mourne and Down', 'ultimate-multisite'),
			'NTA'   => __('Newtownabbey Borough Council', 'ultimate-multisite'),
			'NFK'   => __('Norfolk', 'ultimate-multisite'),
			'NAY'   => __('North Ayrshire', 'ultimate-multisite'),
			'NDN'   => __('North Down Borough Council', 'ultimate-multisite'),
			'NEL'   => __('North East Lincolnshire', 'ultimate-multisite'),
			'NLK'   => __('North Lanarkshire', 'ultimate-multisite'),
			'NLN'   => __('North Lincolnshire', 'ultimate-multisite'),
			'NSM'   => __('North Somerset', 'ultimate-multisite'),
			'NTY'   => __('North Tyneside', 'ultimate-multisite'),
			'NYK'   => __('North Yorkshire', 'ultimate-multisite'),
			'NTH'   => __('Northamptonshire', 'ultimate-multisite'),
			'NIR'   => __('Northern Ireland', 'ultimate-multisite'),
			'NBL'   => __('Northumberland', 'ultimate-multisite'),
			'NTT'   => __('Nottinghamshire', 'ultimate-multisite'),
			'OLD'   => __('Oldham', 'ultimate-multisite'),
			'OMH'   => __('Omagh District Council', 'ultimate-multisite'),
			'ORK'   => __('Orkney Islands', 'ultimate-multisite'),
			'ELS'   => __('Outer Hebrides', 'ultimate-multisite'),
			'OXF'   => __('Oxfordshire', 'ultimate-multisite'),
			'PEM'   => __('Pembrokeshire', 'ultimate-multisite'),
			'PKN'   => __('Perth and Kinross', 'ultimate-multisite'),
			'POL'   => __('Poole', 'ultimate-multisite'),
			'POW'   => __('Powys', 'ultimate-multisite'),
			'RDG'   => __('Reading', 'ultimate-multisite'),
			'RCC'   => __('Redcar and Cleveland', 'ultimate-multisite'),
			'RFW'   => __('Renfrewshire', 'ultimate-multisite'),
			'RCT'   => __('Rhondda Cynon Taf', 'ultimate-multisite'),
			'RCH'   => __('Rochdale', 'ultimate-multisite'),
			'ROT'   => __('Rotherham', 'ultimate-multisite'),
			'GRE'   => __('Royal Borough of Greenwich', 'ultimate-multisite'),
			'KEC'   => __('Royal Borough of Kensington and Chelsea', 'ultimate-multisite'),
			'KTT'   => __('Royal Borough of Kingston upon Thames', 'ultimate-multisite'),
			'RUT'   => __('Rutland', 'ultimate-multisite'),
			'SH-HL' => __('Saint Helena', 'ultimate-multisite'),
			'SLF'   => __('Salford', 'ultimate-multisite'),
			'SAW'   => __('Sandwell', 'ultimate-multisite'),
			'SCT'   => __('Scotland', 'ultimate-multisite'),
			'SCB'   => __('Scottish Borders', 'ultimate-multisite'),
			'SFT'   => __('Sefton', 'ultimate-multisite'),
			'SHF'   => __('Sheffield', 'ultimate-multisite'),
			'ZET'   => __('Shetland Islands', 'ultimate-multisite'),
			'SHR'   => __('Shropshire', 'ultimate-multisite'),
			'SLG'   => __('Slough', 'ultimate-multisite'),
			'SOL'   => __('Solihull', 'ultimate-multisite'),
			'SOM'   => __('Somerset', 'ultimate-multisite'),
			'SAY'   => __('South Ayrshire', 'ultimate-multisite'),
			'SGC'   => __('South Gloucestershire', 'ultimate-multisite'),
			'SLK'   => __('South Lanarkshire', 'ultimate-multisite'),
			'STY'   => __('South Tyneside', 'ultimate-multisite'),
			'SOS'   => __('Southend-on-Sea', 'ultimate-multisite'),
			'SHN'   => __('St Helens', 'ultimate-multisite'),
			'STS'   => __('Staffordshire', 'ultimate-multisite'),
			'STG'   => __('Stirling', 'ultimate-multisite'),
			'SKP'   => __('Stockport', 'ultimate-multisite'),
			'STT'   => __('Stockton-on-Tees', 'ultimate-multisite'),
			'STB'   => __('Strabane District Council', 'ultimate-multisite'),
			'SFK'   => __('Suffolk', 'ultimate-multisite'),
			'SRY'   => __('Surrey', 'ultimate-multisite'),
			'SWD'   => __('Swindon', 'ultimate-multisite'),
			'TAM'   => __('Tameside', 'ultimate-multisite'),
			'TFW'   => __('Telford and Wrekin', 'ultimate-multisite'),
			'THR'   => __('Thurrock', 'ultimate-multisite'),
			'TOB'   => __('Torbay', 'ultimate-multisite'),
			'TOF'   => __('Torfaen', 'ultimate-multisite'),
			'TRF'   => __('Trafford', 'ultimate-multisite'),
			'UKM'   => __('United Kingdom', 'ultimate-multisite'),
			'VGL'   => __('Vale of Glamorgan', 'ultimate-multisite'),
			'WKF'   => __('Wakefield', 'ultimate-multisite'),
			'WLS'   => __('Wales', 'ultimate-multisite'),
			'WLL'   => __('Walsall', 'ultimate-multisite'),
			'WRT'   => __('Warrington', 'ultimate-multisite'),
			'WAR'   => __('Warwickshire', 'ultimate-multisite'),
			'WBK'   => __('West Berkshire', 'ultimate-multisite'),
			'WDU'   => __('West Dunbartonshire', 'ultimate-multisite'),
			'WLN'   => __('West Lothian', 'ultimate-multisite'),
			'WSX'   => __('West Sussex', 'ultimate-multisite'),
			'WIL'   => __('Wiltshire', 'ultimate-multisite'),
			'WNM'   => __('Windsor and Maidenhead', 'ultimate-multisite'),
			'WRL'   => __('Wirral', 'ultimate-multisite'),
			'WOK'   => __('Wokingham', 'ultimate-multisite'),
			'WOR'   => __('Worcestershire', 'ultimate-multisite'),
			'WRX'   => __('Wrexham County Borough', 'ultimate-multisite'),
		];
	}
}
