<?php // phpcs:ignore - @generation-checksum FR-123-8894
/**
 * Country Class for France (FR).
 *
 * State/province count: 123
 * City count: 8894
 * City count per state/province:
 * - 20R: 51 cities
 * - ARA: 1231 cities
 * - NAQ: 968 cities
 * - HDF: 921 cities
 * - GES: 887 cities
 * - OCC: 828 cities
 * - IDF: 694 cities
 * - BRE: 666 cities
 * - PDL: 660 cities
 * - PAC: 535 cities
 * - NOR: 526 cities
 * - CVL: 476 cities
 * - BFC: 451 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for France (FR).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_FR extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'FR',
		'currency'     => 'EUR',
		'phone_code'   => 33,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'region';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('France', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for FR.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'10'  => __('Aube', 'ultimate-multisite'),
			'11'  => __('Aude', 'ultimate-multisite'),
			'12'  => __('Aveyron', 'ultimate-multisite'),
			'13'  => __('Bouches-du-Rhône', 'ultimate-multisite'),
			'14'  => __('Calvados', 'ultimate-multisite'),
			'15'  => __('Cantal', 'ultimate-multisite'),
			'16'  => __('Charente', 'ultimate-multisite'),
			'17'  => __('Charente-Maritime', 'ultimate-multisite'),
			'18'  => __('Cher', 'ultimate-multisite'),
			'19'  => __('Corrèze', 'ultimate-multisite'),
			'21'  => __("Côte-d'Or", 'ultimate-multisite'),
			'22'  => __("Côtes-d'Armor", 'ultimate-multisite'),
			'23'  => __('Creuse', 'ultimate-multisite'),
			'24'  => __('Dordogne', 'ultimate-multisite'),
			'25'  => __('Doubs', 'ultimate-multisite'),
			'26'  => __('Drôme', 'ultimate-multisite'),
			'27'  => __('Eure', 'ultimate-multisite'),
			'28'  => __('Eure-et-Loir', 'ultimate-multisite'),
			'29'  => __('Finistère', 'ultimate-multisite'),
			'30'  => __('Gard', 'ultimate-multisite'),
			'31'  => __('Haute-Garonne', 'ultimate-multisite'),
			'32'  => __('Gers', 'ultimate-multisite'),
			'33'  => __('Gironde', 'ultimate-multisite'),
			'34'  => __('Hérault', 'ultimate-multisite'),
			'35'  => __('Ille-et-Vilaine', 'ultimate-multisite'),
			'36'  => __('Indre', 'ultimate-multisite'),
			'37'  => __('Indre-et-Loire', 'ultimate-multisite'),
			'38'  => __('Isère', 'ultimate-multisite'),
			'39'  => __('Jura', 'ultimate-multisite'),
			'40'  => __('Landes', 'ultimate-multisite'),
			'41'  => __('Loir-et-Cher', 'ultimate-multisite'),
			'42'  => __('Loire', 'ultimate-multisite'),
			'43'  => __('Haute-Loire', 'ultimate-multisite'),
			'44'  => __('Loire-Atlantique', 'ultimate-multisite'),
			'45'  => __('Loiret', 'ultimate-multisite'),
			'46'  => __('Lot', 'ultimate-multisite'),
			'47'  => __('Lot-et-Garonne', 'ultimate-multisite'),
			'48'  => __('Lozère', 'ultimate-multisite'),
			'49'  => __('Maine-et-Loire', 'ultimate-multisite'),
			'50'  => __('Manche', 'ultimate-multisite'),
			'51'  => __('Marne', 'ultimate-multisite'),
			'52'  => __('Haute-Marne', 'ultimate-multisite'),
			'53'  => __('Mayenne', 'ultimate-multisite'),
			'54'  => __('Meurthe-et-Moselle', 'ultimate-multisite'),
			'55'  => __('Meuse', 'ultimate-multisite'),
			'56'  => __('Morbihan', 'ultimate-multisite'),
			'57'  => __('Moselle', 'ultimate-multisite'),
			'58'  => __('Nièvre', 'ultimate-multisite'),
			'59'  => __('Nord', 'ultimate-multisite'),
			'60'  => __('Oise', 'ultimate-multisite'),
			'61'  => __('Orne', 'ultimate-multisite'),
			'62'  => __('Pas-de-Calais', 'ultimate-multisite'),
			'63'  => __('Puy-de-Dôme', 'ultimate-multisite'),
			'64'  => __('Pyrénées-Atlantiques', 'ultimate-multisite'),
			'65'  => __('Hautes-Pyrénées', 'ultimate-multisite'),
			'66'  => __('Pyrénées-Orientales', 'ultimate-multisite'),
			'67'  => __('Bas-Rhin', 'ultimate-multisite'),
			'68'  => __('Haut-Rhin', 'ultimate-multisite'),
			'69'  => __('Rhône', 'ultimate-multisite'),
			'70'  => __('Haute-Saône', 'ultimate-multisite'),
			'71'  => __('Saône-et-Loire', 'ultimate-multisite'),
			'72'  => __('Sarthe', 'ultimate-multisite'),
			'73'  => __('Savoie', 'ultimate-multisite'),
			'74'  => __('Haute-Savoie', 'ultimate-multisite'),
			'76'  => __('Seine-Maritime', 'ultimate-multisite'),
			'77'  => __('Seine-et-Marne', 'ultimate-multisite'),
			'78'  => __('Yvelines', 'ultimate-multisite'),
			'79'  => __('Deux-Sèvres', 'ultimate-multisite'),
			'80'  => __('Somme', 'ultimate-multisite'),
			'81'  => __('Tarn', 'ultimate-multisite'),
			'82'  => __('Tarn-et-Garonne', 'ultimate-multisite'),
			'83'  => __('Var', 'ultimate-multisite'),
			'84'  => __('Vaucluse', 'ultimate-multisite'),
			'85'  => __('Vendée', 'ultimate-multisite'),
			'86'  => __('Vienne', 'ultimate-multisite'),
			'87'  => __('Haute-Vienne', 'ultimate-multisite'),
			'88'  => __('Vosges', 'ultimate-multisite'),
			'89'  => __('Yonne', 'ultimate-multisite'),
			'90'  => __('Territoire de Belfort', 'ultimate-multisite'),
			'91'  => __('Essonne', 'ultimate-multisite'),
			'92'  => __('Hauts-de-Seine', 'ultimate-multisite'),
			'93'  => __('Seine-Saint-Denis', 'ultimate-multisite'),
			'94'  => __('Val-de-Marne', 'ultimate-multisite'),
			'95'  => __("Val-d'Oise", 'ultimate-multisite'),
			'971' => __('Guadeloupe', 'ultimate-multisite'),
			'972' => __('Martinique', 'ultimate-multisite'),
			'973' => __('French Guiana', 'ultimate-multisite'),
			'974' => __('La Réunion', 'ultimate-multisite'),
			'976' => __('Mayotte', 'ultimate-multisite'),
			'01'  => __('Ain', 'ultimate-multisite'),
			'02'  => __('Aisne', 'ultimate-multisite'),
			'03'  => __('Allier', 'ultimate-multisite'),
			'06'  => __('Alpes-Maritimes', 'ultimate-multisite'),
			'04'  => __('Alpes-de-Haute-Provence', 'ultimate-multisite'),
			'6AE' => __('Alsace', 'ultimate-multisite'),
			'08'  => __('Ardennes', 'ultimate-multisite'),
			'07'  => __('Ardèche', 'ultimate-multisite'),
			'09'  => __('Ariège', 'ultimate-multisite'),
			'ARA' => __('Auvergne-Rhône-Alpes', 'ultimate-multisite'),
			'BFC' => __('Bourgogne-Franche-Comté', 'ultimate-multisite'),
			'BRE' => __('Bretagne', 'ultimate-multisite'),
			'CVL' => __('Centre-Val de Loire', 'ultimate-multisite'),
			'CP'  => __('Clipperton', 'ultimate-multisite'),
			'20R' => __('Corse', 'ultimate-multisite'),
			'2A'  => __('Corse-du-Sud', 'ultimate-multisite'),
			'PF'  => __('French Polynesia', 'ultimate-multisite'),
			'TF'  => __('French Southern and Antarctic Lands', 'ultimate-multisite'),
			'GES' => __('Grand-Est', 'ultimate-multisite'),
			'2B'  => __('Haute-Corse', 'ultimate-multisite'),
			'05'  => __('Hautes-Alpes', 'ultimate-multisite'),
			'HDF' => __('Hauts-de-France', 'ultimate-multisite'),
			'69M' => __('Métropole de Lyon', 'ultimate-multisite'),
			'NOR' => __('Normandie', 'ultimate-multisite'),
			'NAQ' => __('Nouvelle-Aquitaine', 'ultimate-multisite'),
			'OCC' => __('Occitanie', 'ultimate-multisite'),
			'75C' => __('Paris', 'ultimate-multisite'),
			'PDL' => __('Pays-de-la-Loire', 'ultimate-multisite'),
			'PAC' => __('Provence-Alpes-Côte-d’Azur', 'ultimate-multisite'),
			'PM'  => __('Saint Pierre and Miquelon', 'ultimate-multisite'),
			'BL'  => __('Saint-Barthélemy', 'ultimate-multisite'),
			'MF'  => __('Saint-Martin', 'ultimate-multisite'),
			'WF'  => __('Wallis and Futuna', 'ultimate-multisite'),
			'IDF' => __('Île-de-France', 'ultimate-multisite'),
		];
	}
}
