<?php // phpcs:ignore - @generation-checksum ES-28-6692
/**
 * Country Class for Spain (ES).
 *
 * State/province count: 28
 * City count: 6692
 * City count per state/province:
 * - LE: 1948 cities
 * - CM: 808 cities
 * - AN: 724 cities
 * - AR: 620 cities
 * - CT: 557 cities
 * - VC: 477 cities
 * - EX: 349 cities
 * - GA: 227 cities
 * - MD: 188 cities
 * - NC: 176 cities
 * - RI: 159 cities
 * - PV: 149 cities
 * - CN: 105 cities
 * - PM: 87 cities
 * - CB: 58 cities
 * - MC: 57 cities
 * - CE: 2 cities
 * - ML: 1 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for Spain (ES).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_ES extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'ES',
		'currency'     => 'EUR',
		'phone_code'   => 34,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'autonomous_community';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('Spain', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for ES.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'AN' => __('Andalusia', 'ultimate-multisite'),
			'AR' => __('Aragon', 'ultimate-multisite'),
			'AS' => __('Asturias', 'ultimate-multisite'),
			'PM' => __('Balearic Islands', 'ultimate-multisite'),
			'PV' => __('Basque Country', 'ultimate-multisite'),
			'BU' => __('Burgos Province', 'ultimate-multisite'),
			'CN' => __('Canary Islands', 'ultimate-multisite'),
			'CB' => __('Cantabria', 'ultimate-multisite'),
			'CL' => __('Castile and León', 'ultimate-multisite'),
			'CM' => __('Castilla La Mancha', 'ultimate-multisite'),
			'CT' => __('Catalonia', 'ultimate-multisite'),
			'CE' => __('Ceuta', 'ultimate-multisite'),
			'EX' => __('Extremadura', 'ultimate-multisite'),
			'GA' => __('Galicia', 'ultimate-multisite'),
			'RI' => __('La Rioja', 'ultimate-multisite'),
			'LE' => __('Léon', 'ultimate-multisite'),
			'MD' => __('Madrid', 'ultimate-multisite'),
			'ML' => __('Melilla', 'ultimate-multisite'),
			'MC' => __('Murcia', 'ultimate-multisite'),
			'NC' => __('Navarra', 'ultimate-multisite'),
			'P'  => __('Palencia Province', 'ultimate-multisite'),
			'SA' => __('Salamanca Province', 'ultimate-multisite'),
			'SG' => __('Segovia Province', 'ultimate-multisite'),
			'SO' => __('Soria Province', 'ultimate-multisite'),
			'VC' => __('Valencia', 'ultimate-multisite'),
			'VA' => __('Valladolid Province', 'ultimate-multisite'),
			'ZA' => __('Zamora Province', 'ultimate-multisite'),
			'AV' => __('Ávila', 'ultimate-multisite'),
		];
	}
}
