<?php // phpcs:ignore - @generation-checksum DE-16-7097
/**
 * Country Class for Germany (DE).
 *
 * State/province count: 16
 * City count: 7097
 * City count per state/province:
 * - BY: 1756 cities
 * - BW: 944 cities
 * - NI: 751 cities
 * - RP: 688 cities
 * - SN: 442 cities
 * - NW: 428 cities
 * - SH: 386 cities
 * - ST: 368 cities
 * - HE: 347 cities
 * - TH: 319 cities
 * - MV: 253 cities
 * - BB: 217 cities
 * - BE: 97 cities
 * - SL: 60 cities
 * - HH: 37 cities
 * - HB: 4 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for Germany (DE).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_DE extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'DE',
		'currency'     => 'EUR',
		'phone_code'   => 49,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'state';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('Germany', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for DE.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'BW' => __('Baden-Württemberg', 'ultimate-multisite'),
			'BY' => __('Bavaria', 'ultimate-multisite'),
			'BE' => __('Berlin', 'ultimate-multisite'),
			'BB' => __('Brandenburg', 'ultimate-multisite'),
			'HB' => __('Bremen', 'ultimate-multisite'),
			'HH' => __('Hamburg', 'ultimate-multisite'),
			'HE' => __('Hesse', 'ultimate-multisite'),
			'NI' => __('Lower Saxony', 'ultimate-multisite'),
			'MV' => __('Mecklenburg-Vorpommern', 'ultimate-multisite'),
			'NW' => __('North Rhine-Westphalia', 'ultimate-multisite'),
			'RP' => __('Rhineland-Palatinate', 'ultimate-multisite'),
			'SL' => __('Saarland', 'ultimate-multisite'),
			'SN' => __('Saxony', 'ultimate-multisite'),
			'ST' => __('Saxony-Anhalt', 'ultimate-multisite'),
			'SH' => __('Schleswig-Holstein', 'ultimate-multisite'),
			'TH' => __('Thuringia', 'ultimate-multisite'),
		];
	}
}
