<?php // phpcs:ignore - @generation-checksum CN-34-1296
/**
 * Country Class for China (CN).
 *
 * State/province count: 34
 * City count: 1296
 * City count per state/province:
 * - HN: 118 cities
 * - FJ: 111 cities
 * - SD: 90 cities
 * - GD: 72 cities
 * - HL: 71 cities
 * - TJ: 69 cities
 * - HB: 55 cities
 * - HA: 55 cities
 * - GZ: 54 cities
 * - JL: 52 cities
 * - TW: 52 cities
 * - LN: 51 cities
 * - SC: 49 cities
 * - ZJ: 41 cities
 * - HE: 39 cities
 * - XJ: 37 cities
 * - AH: 37 cities
 * - NM: 33 cities
 * - YN: 29 cities
 * - GX: 28 cities
 * - GS: 20 cities
 * - CQ: 18 cities
 * - SX: 18 cities
 * - JX: 16 cities
 * - SN: 14 cities
 * - HI: 14 cities
 * - XZ: 13 cities
 * - JS: 13 cities
 * - BJ: 8 cities
 * - QH: 8 cities
 * - NX: 7 cities
 * - SH: 4 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for China (CN).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_CN extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'CN',
		'currency'     => 'CNY',
		'phone_code'   => 86,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'province';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('China', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for CN.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'AH' => __('Anhui', 'ultimate-multisite'),
			'BJ' => __('Beijing', 'ultimate-multisite'),
			'CQ' => __('Chongqing', 'ultimate-multisite'),
			'FJ' => __('Fujian', 'ultimate-multisite'),
			'GS' => __('Gansu', 'ultimate-multisite'),
			'GD' => __('Guangdong', 'ultimate-multisite'),
			'GX' => __('Guangxi Zhuang', 'ultimate-multisite'),
			'GZ' => __('Guizhou', 'ultimate-multisite'),
			'HI' => __('Hainan', 'ultimate-multisite'),
			'HE' => __('Hebei', 'ultimate-multisite'),
			'HL' => __('Heilongjiang', 'ultimate-multisite'),
			'HA' => __('Henan', 'ultimate-multisite'),
			'HK' => __('Hong Kong SAR', 'ultimate-multisite'),
			'HB' => __('Hubei', 'ultimate-multisite'),
			'HN' => __('Hunan', 'ultimate-multisite'),
			'NM' => __('Inner Mongolia', 'ultimate-multisite'),
			'JS' => __('Jiangsu', 'ultimate-multisite'),
			'JX' => __('Jiangxi', 'ultimate-multisite'),
			'JL' => __('Jilin', 'ultimate-multisite'),
			'LN' => __('Liaoning', 'ultimate-multisite'),
			'MO' => __('Macau SAR', 'ultimate-multisite'),
			'NX' => __('Ningxia Huizu', 'ultimate-multisite'),
			'QH' => __('Qinghai', 'ultimate-multisite'),
			'SN' => __('Shaanxi', 'ultimate-multisite'),
			'SD' => __('Shandong', 'ultimate-multisite'),
			'SH' => __('Shanghai', 'ultimate-multisite'),
			'SX' => __('Shanxi', 'ultimate-multisite'),
			'SC' => __('Sichuan', 'ultimate-multisite'),
			'TW' => __('Taiwan', 'ultimate-multisite'),
			'TJ' => __('Tianjin', 'ultimate-multisite'),
			'XJ' => __('Xinjiang', 'ultimate-multisite'),
			'XZ' => __('Xizang', 'ultimate-multisite'),
			'YN' => __('Yunnan', 'ultimate-multisite'),
			'ZJ' => __('Zhejiang', 'ultimate-multisite'),
		];
	}
}
