<?php // phpcs:ignore - @generation-checksum CA-13-1079
/**
 * Country Class for Canada (CA).
 *
 * State/province count: 13
 * City count: 1079
 * City count per state/province:
 * - QC: 351 cities
 * - ON: 239 cities
 * - BC: 139 cities
 * - AB: 115 cities
 * - SK: 54 cities
 * - MB: 43 cities
 * - NS: 43 cities
 * - NB: 37 cities
 * - NL: 32 cities
 * - PE: 9 cities
 * - NT: 7 cities
 * - NU: 6 cities
 * - YT: 4 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for Canada (CA).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_CA extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'CA',
		'currency'     => 'CAD',
		'phone_code'   => 1,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'province';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('Canada', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for CA.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'AB' => __('Alberta', 'ultimate-multisite'),
			'BC' => __('British Columbia', 'ultimate-multisite'),
			'MB' => __('Manitoba', 'ultimate-multisite'),
			'NB' => __('New Brunswick', 'ultimate-multisite'),
			'NL' => __('Newfoundland and Labrador', 'ultimate-multisite'),
			'NT' => __('Northwest Territories', 'ultimate-multisite'),
			'NS' => __('Nova Scotia', 'ultimate-multisite'),
			'NU' => __('Nunavut', 'ultimate-multisite'),
			'ON' => __('Ontario', 'ultimate-multisite'),
			'PE' => __('Prince Edward Island', 'ultimate-multisite'),
			'QC' => __('Quebec', 'ultimate-multisite'),
			'SK' => __('Saskatchewan', 'ultimate-multisite'),
			'YT' => __('Yukon', 'ultimate-multisite'),
		];
	}
}
