<?php // phpcs:ignore - @generation-checksum BR-27-5640
/**
 * Country Class for Brazil (BR).
 *
 * State/province count: 27
 * City count: 5640
 * City count per state/province:
 * - MG: 856 cities
 * - SP: 653 cities
 * - RS: 501 cities
 * - BA: 421 cities
 * - PR: 400 cities
 * - SC: 314 cities
 * - GO: 246 cities
 * - PI: 225 cities
 * - PB: 223 cities
 * - MA: 219 cities
 * - PE: 193 cities
 * - CE: 187 cities
 * - RN: 169 cities
 * - PA: 147 cities
 * - MT: 143 cities
 * - TO: 139 cities
 * - AL: 102 cities
 * - RJ: 94 cities
 * - MS: 82 cities
 * - ES: 79 cities
 * - SE: 75 cities
 * - AM: 62 cities
 * - RO: 56 cities
 * - AC: 22 cities
 * - AP: 16 cities
 * - RR: 14 cities
 * - DF: 2 cities
 *
 * @package WP_Ultimo\Country
 * @since 2.0.11
 */

namespace WP_Ultimo\Country;

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Country Class for Brazil (BR).
 *
 * IMPORTANT:
 * This file is generated by build scripts, do not
 * change it directly or your changes will be LOST!
 *
 * @since 2.0.11
 *
 * @property-read string $code
 * @property-read string $currency
 * @property-read int $phone_code
 */
class Country_BR extends Country {

	use \WP_Ultimo\Traits\Singleton;

	/**
	 * General country attributes.
	 *
	 * This might be useful, might be not.
	 * In case of doubt, keep it.
	 *
	 * @since 2.0.11
	 * @var array
	 */
	protected $attributes = [
		'country_code' => 'BR',
		'currency'     => 'BRL',
		'phone_code'   => 55,
	];

	/**
	 * The type of nomenclature used to refer to the country sub-divisions.
	 *
	 * @since 2.0.11
	 * @var string
	 */
	protected $state_type = 'state';

	/**
	 * Return the country name.
	 *
	 * @since 2.0.11
	 * @return string
	 */
	public function get_name() {

		return __('Brazil', 'ultimate-multisite');
	}

	/**
	 * Returns the list of states for BR.
	 *
	 * @since 2.0.11
	 * @return array The list of state/provinces for the country.
	 */
	protected function states() {

		return [
			'AC' => __('Acre', 'ultimate-multisite'),
			'AL' => __('Alagoas', 'ultimate-multisite'),
			'AP' => __('Amapá', 'ultimate-multisite'),
			'AM' => __('Amazonas', 'ultimate-multisite'),
			'BA' => __('Bahia', 'ultimate-multisite'),
			'CE' => __('Ceará', 'ultimate-multisite'),
			'DF' => __('Distrito Federal', 'ultimate-multisite'),
			'ES' => __('Espírito Santo', 'ultimate-multisite'),
			'GO' => __('Goiás', 'ultimate-multisite'),
			'MA' => __('Maranhão', 'ultimate-multisite'),
			'MT' => __('Mato Grosso', 'ultimate-multisite'),
			'MS' => __('Mato Grosso do Sul', 'ultimate-multisite'),
			'MG' => __('Minas Gerais', 'ultimate-multisite'),
			'PR' => __('Paraná', 'ultimate-multisite'),
			'PB' => __('Paraíba', 'ultimate-multisite'),
			'PA' => __('Pará', 'ultimate-multisite'),
			'PE' => __('Pernambuco', 'ultimate-multisite'),
			'PI' => __('Piauí', 'ultimate-multisite'),
			'RN' => __('Rio Grande do Norte', 'ultimate-multisite'),
			'RS' => __('Rio Grande do Sul', 'ultimate-multisite'),
			'RJ' => __('Rio de Janeiro', 'ultimate-multisite'),
			'RO' => __('Rondônia', 'ultimate-multisite'),
			'RR' => __('Roraima', 'ultimate-multisite'),
			'SC' => __('Santa Catarina', 'ultimate-multisite'),
			'SE' => __('Sergipe', 'ultimate-multisite'),
			'SP' => __('São Paulo', 'ultimate-multisite'),
			'TO' => __('Tocantins', 'ultimate-multisite'),
		];
	}
}
