<?php
/**
 * Schema for webhook@update.
 *
 * @package WP_Ultimo\API\Schemas
 * @since 2.0.11
 */

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Schema for webhook@update.
 *
 * @since 2.0.11
 * @internal last-generated in 2022-12
 * @generated class generated by our build scripts, do not change!
 *
 * @since 2.0.11
 */
return [
	'name'             => [
		'description' => __('Webhook name, which is used as product title as well.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'webhook_url'      => [
		'description' => __('The URL used for the webhook call.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'event'            => [
		'description' => __('The event that needs to be fired for this webhook to be sent.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'event_count'      => [
		'description' => __('How many times this webhook was sent.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'active'           => [
		'description' => __('Set this webhook as active (true), which means available will fire when the event occur, or inactive (false).', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'hidden'           => [
		'description' => __('Is this webhook hidden.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'date_created'     => [
		'description' => __('Date when this was created.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'integration'      => [
		'description' => __('The integration that created this webhook.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'date_last_failed' => [
		'description' => __('The date when this webhook last fail.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'date_modified'    => [
		'description' => __('Model last modification date.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'migrated_from_id' => [
		'description' => __('The ID of the original 1.X model that was used to generate this item on migration.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'skip_validation'  => [
		'description' => __('Set true to have field information validation bypassed when saving this event.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
];
