<?php
/**
 * Schema for site@update.
 *
 * @package WP_Ultimo\API\Schemas
 * @since 2.0.11
 */

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Schema for site@update.
 *
 * @since 2.0.11
 * @internal last-generated in 2022-12
 * @generated class generated by our build scripts, do not change!
 *
 * @since 2.0.11
 */
return [
	'categories'        => [
		'description' => __('The categories this site belongs to.', 'ultimate-multisite'),
		'type'        => 'array',
		'required'    => false,
	],
	'featured_image_id' => [
		'description' => __('The ID of the feature image of the site.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'site_id'           => [
		'description' => __('The network ID for this site.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'title'             => [
		'description' => __('The site title.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'name'              => [
		'description' => __('The site name.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'description'       => [
		'description' => __('A description for the site, usually a short text.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'domain'            => [
		'description' => __("The site domain. You don't need to put http or https in front of your domain in this field. e.g: example.com.", 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'path'              => [
		'description' => __('Path of the site. Used when in sub-directory mode.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'registered'        => [
		'description' => __('Date when the site was registered.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'last_updated'      => [
		'description' => __('Date of the last update on this site.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'active'            => [
		'description' => __('Holds the ID of the customer that owns this site.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'public'            => [
		'description' => __('Set true if this site is a public one, false if not.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'archived'          => [
		'description' => __('Is this an archived site.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'mature'            => [
		'description' => __('Is this a site with mature content.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'spam'              => [
		'description' => __('Is this an spam site.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'deleted'           => [
		'description' => __('Is this site deleted.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'lang_id'           => [
		'description' => __('The ID of the language being used on this site.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'customer_id'       => [
		'description' => __('The ID of the customer that owns this site.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'membership_id'     => [
		'description' => __('The ID of the membership associated with this site, if any.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'template_id'       => [
		'description' => __('The ID of the templated used to create this site.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'type'              => [
		'description' => __('The type of this particular site. Can be default, site_template, customer_owned, pending, external, main or other values added by third-party add-ons.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
		'enum'        => [
			'default',
			'site_template',
			'customer_owned',
			'pending',
			'external',
			'main',
		],
	],
	'signup_options'    => [
		'description' => __('Keeps signup options for the site.', 'ultimate-multisite'),
		'type'        => 'array',
		'required'    => false,
	],
	'signup_meta'       => [
		'description' => __('Keeps signup meta for the site.', 'ultimate-multisite'),
		'type'        => 'array',
		'required'    => false,
	],
	'date_created'      => [
		'description' => __('Model creation date.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'date_modified'     => [
		'description' => __('Model last modification date.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'migrated_from_id'  => [
		'description' => __('The ID of the original 1.X model that was used to generate this item on migration.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'skip_validation'   => [
		'description' => __('Set true to have field information validation bypassed when saving this event.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
];
