<?php
/**
 * Schema for email@create.
 *
 * @package WP_Ultimo\API\Schemas
 * @since 2.0.11
 */

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Schema for email@create.
 *
 * @since 2.0.11
 * @internal last-generated in 2022-12
 * @generated class generated by our build scripts, do not change!
 *
 * @since 2.0.11
 */
return [
	'style'               => [
		'description' => __("The email style. Can be 'html' or 'plain-text'.", 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
		'enum'        => [
			'html',
			'plain-text',
		],
	],
	'schedule'            => [
		'description' => __('Whether or not this is a scheduled email.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'type'                => [
		'description' => __('The type being set.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'event'               => [
		'description' => __('The event that needs to be fired for this email to be sent.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => true,
	],
	'send_hours'          => [
		'description' => __('The amount of hours that the email will wait before is sent.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'send_days'           => [
		'description' => __('The amount of days that the email will wait before is sent.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'schedule_type'       => [
		'description' => __("The type of schedule. Can be 'days' or 'hours'.", 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
		'enum'        => [
			'days',
			'hours',
		],
	],
	'name'                => [
		'description' => __('The name being set as title.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'custom_sender'       => [
		'description' => __('If has a custom sender.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'custom_sender_name'  => [
		'description' => __('The name of the custom sender. E.g. From: John Doe.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'custom_sender_email' => [
		'description' => __('The email of the custom sender. E.g. From: johndoe@gmail.com.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'target'              => [
		'description' => __("If we should send this to a customer or to the network admin. Can be 'customer' or 'admin'.", 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => true,
		'enum'        => [
			'customer',
			'admin',
		],
	],
	'send_copy_to_admin'  => [
		'description' => __('Checks if we should send a copy of the email to the admin.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'active'              => [
		'description' => __('Set this email as active (true), which means available will fire when the event occur, or inactive (false).', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'legacy'              => [
		'description' => __('Whether or not this is a legacy email.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
	'title'               => [
		'description' => __('Post title.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => true,
	],
	'content'             => [
		'description' => __('Post content.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'excerpt'             => [
		'description' => __('Post excerpt.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'date_created'        => [
		'description' => __('Post creation date.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'date_modified'       => [
		'description' => __('Post last modification date.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'migrated_from_id'    => [
		'description' => __('The ID of the original 1.X model that was used to generate this item on migration.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'skip_validation'     => [
		'description' => __('Set true to have field information validation bypassed when saving this event.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
];
