<?php
/**
 * Schema for checkout@form-create.
 *
 * @package WP_Ultimo\API\Schemas
 * @since 2.0.11
 */

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Schema for checkout@form-create.
 *
 * @since 2.0.11
 * @internal last-generated in 2022-12
 * @generated class generated by our build scripts, do not change!
 *
 * @since 2.0.11
 */
return [
	'slug'                => [
		'description' => __('The checkout form slug. It needs to be unique and preferably make it clear what it is about. E.g. my_checkout_form.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => true,
	],
	'name'                => [
		'description' => __('Your checkout form name, which is used as checkout form title as well.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => true,
	],
	'active'              => [
		'description' => __('Set this checkout form as active (true), which means available to be used, or inactive (false).', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => true,
	],
	'custom_css'          => [
		'description' => __('Custom CSS code for the checkout form.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'settings'            => [
		'description' => __('The checkout form settings and configurations.', 'ultimate-multisite'),
		'type'        => 'object',
		'required'    => false,
	],
	'allowed_countries'   => [
		'description' => __('The allowed countries that can access this checkout.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'thank_you_page_id'   => [
		'description' => __('The thank you page ID. This page is shown after a successful purchase.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'conversion_snippets' => [
		'description' => __('Snippets to run on thank you page.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'template'            => [
		'description' => __("Template mode. Can be either 'blank', 'single-step' or 'multi-step'.", 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
		'enum'        => [
			'blank',
			'single-step',
			'multi-step',
		],
	],
	'date_created'        => [
		'description' => __('Model creation date.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'date_modified'       => [
		'description' => __('Model last modification date.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'migrated_from_id'    => [
		'description' => __('The ID of the original 1.X model that was used to generate this item on migration.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'skip_validation'     => [
		'description' => __('Set true to have field information validation bypassed when saving this event.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
];
