<?php
/**
 * Schema for broadcast@update.
 *
 * @package WP_Ultimo\API\Schemas
 * @since 2.0.11
 */

// Exit if accessed directly
defined('ABSPATH') || exit;

/**
 * Schema for broadcast@update.
 *
 * @since 2.0.11
 * @internal last-generated in 2022-12
 * @generated class generated by our build scripts, do not change!
 *
 * @since 2.0.11
 */
return [
	'migrated_from_id' => [
		'description' => __('The ID of the original 1.X model that was used to generate this item on migration.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'notice_type'      => [
		'description' => __('Can be info, success, warning or error.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
		'enum'        => [
			'info',
			'success',
			'warning',
			'error',
		],
	],
	'name'             => [
		'description' => __('This broadcast name, which is used as broadcast title as well.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'type'             => [
		'description' => __('The type being set.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'status'           => [
		'description' => __('The status being set.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'author_id'        => [
		'description' => __('The author ID.', 'ultimate-multisite'),
		'type'        => 'integer',
		'required'    => false,
	],
	'title'            => [
		'description' => __('Post title.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'content'          => [
		'description' => __('Post content.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'excerpt'          => [
		'description' => __('Post excerpt.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'date_created'     => [
		'description' => __('Post creation date.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'date_modified'    => [
		'description' => __('Post last modification date.', 'ultimate-multisite'),
		'type'        => 'string',
		'required'    => false,
	],
	'slug'             => [
		'description' => __('The slug.', 'ultimate-multisite'),
		'type'        => 'mixed',
		'required'    => false,
	],
	'skip_validation'  => [
		'description' => __('Set true to have field information validation bypassed when saving this event.', 'ultimate-multisite'),
		'type'        => 'boolean',
		'required'    => false,
	],
];
