<?php
/**
 * Plugin Name: Ukrainian Cyrillic to Latin by OSTG
 * Plugin URI: https://ostg.blog/ukrainian-cyrillic-to-latin-by-ostg
 * Description: Automatically transliterates Ukrainian Cyrillic characters to Latin characters in posts, pages, categories, tags, and media titles for better SEO and URL readability.
 * Version: 1.0.1
 * Requires at least: 5.2
 * Requires PHP: 7.2
 * Author: OSTG
 * Author URI: https://ostg.blog
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: ukrainian-cyrillic-to-latin-by-ostg
 * Domain Path: /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Check if WordPress is loaded
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('UKRAINIAN_CYRILLIC_TO_LATIN_VERSION', '1.0.1');
define('UKRAINIAN_CYRILLIC_TO_LATIN_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('UKRAINIAN_CYRILLIC_TO_LATIN_PLUGIN_URL', plugin_dir_url(__FILE__));
define('UKRAINIAN_CYRILLIC_TO_LATIN_PLUGIN_FILE', __FILE__);

/**
 * Activate the plugin.
 */
function ukrainian_cyrillic_to_latin_activate() {
    // Set default options
    if (!get_option('ukrainian_cyrillic_to_latin_settings')) {
        add_option('ukrainian_cyrillic_to_latin_settings', array(
            'remove_apostrophes' => 1,
            'convert_to_lowercase' => 1
        ));
    }
    
    // Clear rewrite rules
    flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'ukrainian_cyrillic_to_latin_activate');

/**
 * Deactivate the plugin.
 */
function ukrainian_cyrillic_to_latin_deactivate() {
    // Clear rewrite rules
    flush_rewrite_rules();
}
register_deactivation_hook(__FILE__, 'ukrainian_cyrillic_to_latin_deactivate');

/**
 * Add plugin action links.
 */
function ukrainian_cyrillic_to_latin_plugin_action_links($links) {
    $settings_link = '<a href="' . admin_url('options-general.php?page=ukrainian-cyrillic-to-latin-by-ostg') . '">' . __('Settings', 'ukrainian-cyrillic-to-latin-by-ostg') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'ukrainian_cyrillic_to_latin_plugin_action_links');

/**
 * The core plugin class.
 */
require plugin_dir_path(__FILE__) . 'includes/class-ukrainian-cyrillic-to-latin.php';

/**
 * Begins execution of the plugin.
 * 
 * @since 1.0.0
 */
function ukrainian_cyrillic_to_latin_by_ostg_run() {
    $plugin = new Ukrainian_Cyrillic_To_Latin();
    $plugin->run();
}
ukrainian_cyrillic_to_latin_by_ostg_run();