<?php
/**
 * The core plugin class.
 *
 * @since      1.0.0
 * @package    Ukrainian_Cyrillic_To_Latin
 * @subpackage Ukrainian_Cyrillic_To_Latin/includes
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * @since      1.0.0
 * @package    Ukrainian_Cyrillic_To_Latin
 * @subpackage Ukrainian_Cyrillic_To_Latin/includes
 */
class Ukrainian_Cyrillic_To_Latin {

    /**
     * The loader that's responsible for maintaining and registering all hooks that power
     * the plugin.
     *
     * @since    1.0.0
     * @access   protected
     * @var      Ukrainian_Cyrillic_To_Latin_Loader    $loader    Maintains and registers all hooks for the plugin.
     */
    protected $loader;

    /**
     * Define the core functionality of the plugin.
     *
     * @since    1.0.0
     */
    public function __construct() {
        $this->load_dependencies();
        $this->define_admin_hooks();
        $this->define_public_hooks();
    }

    /**
     * Load the required dependencies for this plugin.
     *
     * @since    1.0.0
     * @access   private
     */
    private function load_dependencies() {
        /**
         * The class responsible for orchestrating the actions and filters of the
         * core plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-ukrainian-cyrillic-to-latin-loader.php';

        /**
         * The class responsible for defining all actions that occur in the admin area.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/class-ukrainian-cyrillic-to-latin-admin.php';

        /**
         * The class responsible for defining all actions that occur in the public-facing
         * side of the site.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/class-ukrainian-cyrillic-to-latin-public.php';

        $this->loader = new Ukrainian_Cyrillic_To_Latin_Loader();
    }

    /**
     * Register all of the hooks related to the admin area functionality
     * of the plugin.
     *
     * @since    1.0.0
     * @access   private
     */
    private function define_admin_hooks() {
        $plugin_admin = new Ukrainian_Cyrillic_To_Latin_Admin();
        
        $this->loader->add_action('admin_menu', $plugin_admin, 'add_settings_page');
        $this->loader->add_action('admin_init', $plugin_admin, 'register_settings');
        $this->loader->add_action('admin_notices', $plugin_admin, 'admin_notices');
    }

    /**
     * Register all of the hooks related to the public-facing functionality
     * of the plugin.
     *
     * @since    1.0.0
     * @access   private
     */
    private function define_public_hooks() {
        $plugin_public = new Ukrainian_Cyrillic_To_Latin_Public();
        
        // Transliteration hooks
        $this->loader->add_filter('sanitize_title', $plugin_public, 'transliterate_title', 9);
        $this->loader->add_filter('sanitize_file_name', $plugin_public, 'transliterate_filename', 10);
        $this->loader->add_filter('sanitize_term_slug', $plugin_public, 'transliterate_term_slug', 10, 2);
        $this->loader->add_filter('wp_insert_attachment_data', $plugin_public, 'transliterate_attachment_title', 10, 2);
    }

    /**
     * Run the loader to execute all of the hooks with WordPress.
     *
     * @since    1.0.0
     */
    public function run() {
        $this->loader->run();
    }
}
