<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class TwoStB_Step_Provider{
    public static function get_instance() {
		static $instances = array();

		$class_name = static::class;

		if ( ! isset( $instances[ $class_name ] ) ) {
			$instances[ $class_name ] = new $class_name;
		}

		return $instances[ $class_name ];
	}
    public function __construct() {
		return $this;
	}
    
    public function get_key() {
		return get_class( $this );
	}

    public static function get_code( $length = 8, $chars = '1234567890' ) {
		$code = '';
		if ( is_array( $chars ) ) {
			$chars = implode( '', $chars );
		}
		for ( $i = 0; $i < $length; $i++ ) {
			$code .= substr( $chars, wp_rand( 0, strlen( $chars ) - 1 ), 1 );
		}
		return $code;
	}
}