<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class TwoStB_Step_Factor_Dummy extends TwoStB_Step_Provider {
    
    const USER_DUMMY_CODE = '_twoStB_step_factor_dummy_code';
    
	public function __construct() {
		add_action( 'twoStB_factor_user_options_' . __CLASS__, array( $this, 'user_options' ) );
		parent::__construct();
	}

	public function get_label() {
		return _x( 'Dummy Method', 'Provider Label', 'two-step-factor-by-se' );
	}
	
	public function get_alternative_provider_label() {
		return sprintf(
			/* translators: the two factor provider name */
			__( 'Use %s', 'two-step-factor-by-se' ),
			'Dummy Method'
		);
	}

	public function validate_authentication( $user ) {
		return true;
	}
    
    public function validate_token( $user_id, $code ) {
		$metaCode = get_user_meta( $user_id, self::USER_DUMMY_CODE, true );
		if ( empty( $metaCode ) ) {
			return ['status' => 0, 'error' => 'Dummy code is not set.'];
		}
		if( $metaCode == $code ){
		    return ['status' => 1];
		}else{
		    return ['status' => 0, 'error' => 'Code is invalid.'];
		}
	}
	
	public function is_available_for_user( $user ) {
		return true;
	}
    
    public function authentication_page( $user ) {
		if ( ! $user ) {
			return;
		}
        $token_placeholder = str_repeat( 'X', 8 );
        
		require_once ABSPATH . '/wp-admin/includes/template.php';
		?>
		<p class="two-factor-prompt"><?php esc_html_e( 'Please enter your two factor dummy code.', 'two-step-factor-by-se' ); ?></p>
		<p>
			<label for="authcode"><?php esc_html_e( 'Verification Code:', 'two-step-factor-by-se' ); ?></label>
			<input type="text" inputmode="numeric" name="two-provider-auth-code" id="authcode" class="input authcode" value="" size="20" pattern="[0-9 ]*" autocomplete="one-time-code" placeholder="<?php echo esc_attr( $token_placeholder ); ?>" data-digits="8" />
			<?php submit_button( __( 'Log In', 'two-step-factor-by-se' ) ); ?>
		</p>

		<script type="text/javascript">
			setTimeout( function(){
				var d;
				try{
					d = document.getElementById('authcode');
					d.value = '';
					d.focus();
				} catch(e){}
			}, 200);
		</script>
		<?php
	}
	
	public function user_options( $user ) {
        $user_dummy_code = get_user_meta( $user->ID, self::USER_DUMMY_CODE, true );
		?>
		<div>
			<?php
			echo esc_html(
				sprintf(
				/* translators: %s: email address */
					__( 'Use this code %d to login.', 'two-step-factor-by-se' ),
					$user_dummy_code
				)
			);
			?>
		</div>
		<?php
	}
}
