<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class TwoStB_Step_Factor_BackupCodes extends TwoStB_Step_Provider {
    
    const USER_BACKUPS_CODE = '_twoStB_step_factor_backup_code';
    
	public function __construct() {
		add_action( 'twoStB_factor_user_options_' . __CLASS__, array( $this, 'user_options' ) );
		parent::__construct();
	}

	public function get_label() {
		return _x( 'Backups Codes', 'Provider Label', 'two-step-factor-by-se' );
	}
	
	public function get_alternative_provider_label() {
		return sprintf(
			/* translators: the two factor provider name */
			__( 'Use %s', 'two-step-factor-by-se' ),
			'Backups Codes'
		);
	}
    
    public function validate_token( $user_id, $code ) {
        $backupCodes = get_user_meta($user_id, self::USER_BACKUPS_CODE, true);
        // Check if the code exists (since keys are codes)
        if( empty($backupCodes) ){
            return ['status' => 0, 'error' => 'Backup codes are not generated.'];
        }
        if (isset($backupCodes[$code])) {
            if( $backupCodes[$code] === 1 ){
                return ['status' => 0, 'error' => 'Code is already used.'];
            }else{
                // Update the code's value to 1 (mark as used)
                $backupCodes[$code] = 1;
                update_user_meta($user_id, self::USER_BACKUPS_CODE, $backupCodes);
                return ['status' => 1];
            }
        } else {
            return ['status' => 0, 'error' => 'Code is invalid.'];
        }
    }
	
	public function is_available_for_user( $user ) {
		return true;
	}
    
    public function authentication_page( $user ) {
		if ( ! $user ) {
			return;
		}
        $token_placeholder = str_repeat( 'X', 8 );
        
		require_once ABSPATH . '/wp-admin/includes/template.php';
		?>
		<p class="two-factor-prompt"><?php esc_html_e( 'Please enter your backup code.', 'two-step-factor-by-se' ); ?></p>
		<p>
			<label for="authcode"><?php esc_html_e( 'Verification Code:', 'two-step-factor-by-se' ); ?></label>
			<input type="text" inputmode="numeric" name="two-provider-auth-code" id="authcode" class="input authcode" value="" size="20" pattern="[0-9 ]*" autocomplete="one-time-code" placeholder="<?php echo esc_attr( $token_placeholder ); ?>" data-digits="8" />
			<?php submit_button( __( 'Log In', 'two-step-factor-by-se' ) ); ?>
		</p>

		<script type="text/javascript">
			setTimeout( function(){
				var d;
				try{
					d = document.getElementById('authcode');
					d.value = '';
					d.focus();
				} catch(e){}
			}, 200);
		</script>
		<?php
	}
	
	public function user_options( $user ) {
        $user_backups_codes = get_user_meta( $user->ID, self::USER_BACKUPS_CODE, true );
        if (!empty($user_backups_codes) && is_array($user_backups_codes)) {
            $countOfOnes = count(array_filter($user_backups_codes, function($value) {
                return $value == 1;
            }));
            ?>
            <div>
                <p><?php esc_html_e('Use the codes below to log in:', 'two-step-factor-by-se'); ?></p>
                <ul>
                    <?php foreach ($user_backups_codes as $code => $status) { ?>
                        <li><?php echo esc_html($code); ?> (<?php echo $status ? 'Used' : 'Unused'; ?>)</li>
                    <?php } ?>
                </ul>
                <?php
                if( $countOfOnes > 5 ){
                    echo '<button type="button" class="button button-primary" id="update_backup_codes_btn">Re-generate Codes</button>';
                } ?>
            </div>
        <?php }
    }
    
}
