jQuery(document).ready(function($) {
    $('#update_backup_codes_btn').on('click', function() {
        var $btn = $(this);
        $btn.text('Generating...');  // Change the button text while AJAX is running
        $btn.prop('disabled', true);
        var enabledProviders = [];
        $('input[name="_twoStB_step_factor_enabled_providers[]"]:checked').each(function() {
            enabledProviders.push($(this).val());
        });
        $.ajax({
            url: updateBackupCodesNonce.ajax_url, // WordPress AJAX URL
            type: 'POST',
            data: {
                action: 'update_backup_codes',
                security: updateBackupCodesNonce.nonce, // Nonce for security
                user_id: $('#user_id').val(), // Optional: Pass user ID
                _twoStB_step_factor_enabled_providers: enabledProviders,
            },
            success: function(response) {
                if (response.success) {
                    alert(response.data.message); // Show success message
                    location.reload();
                } else {
                    alert('Error: ' + response.data.message);
                }
            },
            error: function(xhr, status, error) {
                console.error(xhr.responseText); // Debug the error
                alert('AJAX Error: ' + xhr.status + ' ' + xhr.statusText);
            },
            complete: function() {
                // Reset the button text and enable it again after the AJAX completes
                $btn.text('Re-generate Codes'); // Reset the button text back to original
                $btn.prop('disabled', false);  // Re-enable the button after completion
            }
        });
    });
});
