<?php
// Exit if accessed directly
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Delete all plugin data
 */
function twssc_simple_slider_remove_all_data() {
    
    // Step 1: Delete all slider posts
    $page = 1;
    $posts_per_page = 100;
    
    do {
        $sliders = get_posts(array(
            'post_type'      => 'twssc_slider',
            'posts_per_page' => $posts_per_page,
            'paged'          => $page,
            'post_status'    => 'any',
            'fields'         => 'ids',
            'no_found_rows'  => true,
        ));
        
        if (empty($sliders)) {
            break;
        }
        
        foreach ($sliders as $slider_id) {
            // Delete post and all its meta
            wp_delete_post($slider_id, true);
        }
        
        $page++;
        
    } while (count($sliders) === $posts_per_page);
    
    // Step 2: Delete plugin options
    delete_option('twssc_simple_slider_version');
    delete_option('twssc_slider_settings');
    
    // Step 3: Clear any object cache
    if (function_exists('wp_cache_flush')) {
        wp_cache_flush();
    }
}

// Execute cleanup
twssc_simple_slider_remove_all_data();