<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class TW_SIMPLE_SLIDER_Tutorial {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('admin_menu', array($this, 'twssc_add_tutorial_page'));
    }
    
    public function twssc_add_tutorial_page() {
        add_submenu_page(
            'edit.php?post_type=' . TW_SIMPLE_SLIDER_POST_TYPE,
            __('TW Simple Slider Tutorial', 'tw-simple-slider'),
            __('Tutorial', 'tw-simple-slider'),
            'manage_options',
            'tw-simple-slider-tutorial',
            array($this, 'twssc_render_tutorial_page')
        );
    }
    
    public function twssc_render_tutorial_page() {
        ?>
        <div class="wrap">
            <h1><?php esc_html_e('TW Simple Slider - Complete Tutorial', 'tw-simple-slider'); ?></h1>
            
            <h2><?php esc_html_e('How to Use TW Simple Slider Plugin', 'tw-simple-slider'); ?></h2>
            <p><?php esc_html_e('Follow these simple steps to create beautiful sliders for your website:', 'tw-simple-slider'); ?></p>
            
            <ul style="margin-left: 20px; list-style: disc;">
                <li><?php esc_html_e('Click on "TW Sliders" in the left menu', 'tw-simple-slider'); ?></li>
                <li><?php esc_html_e('Click "Add New Slider"', 'tw-simple-slider'); ?></li>
                <li><?php esc_html_e('After saving your slider, you will see a shortcode in the sidebar', 'tw-simple-slider'); ?></li>
                <li><?php esc_html_e('Example shortcode:', 'tw-simple-slider'); ?> <code>[twssc_slider id="123"]</code></li>
                <li><strong><?php esc_html_e('In Posts/Pages:', 'tw-simple-slider'); ?></strong> <?php esc_html_e('Simply paste the shortcode in the content editor', 'tw-simple-slider'); ?></li>
                <li><strong><?php esc_html_e('In Widgets:', 'tw-simple-slider'); ?></strong> <?php esc_html_e('Use the Text widget and paste the shortcode', 'tw-simple-slider'); ?></li>
                <li><strong><?php esc_html_e('In Theme Files:', 'tw-simple-slider'); ?></strong> <?php esc_html_e('Use: ', 'tw-simple-slider'); ?> <code>&lt;?php echo do_shortcode('[twssc_slider id="123"]'); ?&gt;</code></li>
                <li><strong><?php esc_html_e('In Page Builders:', 'tw-simple-slider'); ?></strong> <?php esc_html_e('Most page builders have a shortcode block/widget', 'tw-simple-slider'); ?></li>
            </ul>
        </div>
        <?php
    }
}