<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class TW_SIMPLE_SLIDER_Shortcode {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_shortcode('twssc_slider', array($this, 'twssc_render_slider'));
    }
    
    public function twssc_render_slider($atts) {
        $atts = shortcode_atts(array('id' => 0), $atts, 'twssc_slider');
        $slider_id = absint($atts['id']);
        
        if (!$slider_id || get_post_status($slider_id) !== 'publish') {
            return '';
        }
        
        $images = get_post_meta($slider_id, '_twssc_slider_images', true);
        $slides_to_show = get_post_meta($slider_id, '_twssc_slider_slides_to_show', true);
        $fade_animation = get_post_meta($slider_id, '_twssc_slider_fade_animation', true);
        $show_arrows = get_post_meta($slider_id, '_twssc_slider_show_arrows', true);
        $show_dots = get_post_meta($slider_id, '_twssc_slider_show_dots', true);
        $autoplay = get_post_meta($slider_id, '_twssc_slider_autoplay', true);
        $pause_on_hover = get_post_meta($slider_id, '_twssc_slider_pause_on_hover', true);
        $custom_style = get_post_meta($slider_id, '_twssc_slider_custom_style', true);
        
        $slides_to_show = $slides_to_show ?: '1';
        $fade_animation = $fade_animation !== '' ? $fade_animation : 'no';
        $show_arrows = $show_arrows !== '' ? $show_arrows : 'yes';
        $show_dots = $show_dots !== '' ? $show_dots : 'yes';
        $autoplay = $autoplay !== '' ? $autoplay : 'yes';
        $pause_on_hover = $pause_on_hover !== '' ? $pause_on_hover : 'no';
        
        $custom_arrow_prev_url = '';
        $custom_arrow_next_url = '';
        if (isset($custom_style['custom_arrow_prev']) && $custom_style['custom_arrow_prev']) {
            $custom_arrow_prev_url = wp_get_attachment_url($custom_style['custom_arrow_prev']);
        }
        if (isset($custom_style['custom_arrow_next']) && $custom_style['custom_arrow_next']) {
            $custom_arrow_next_url = wp_get_attachment_url($custom_style['custom_arrow_next']);
        }
        
        $slides_to_show = absint($slides_to_show);
        if ($slides_to_show < 1) $slides_to_show = 1;
        
        if ($slides_to_show !== 1) {
            $fade_animation = 'no';
        }
        
        if (empty($images) || !is_array($images)) {
            return '<p class="twssc-slider-error">' . esc_html__('No images found.', 'tw-simple-slider') . '</p>';
        }
        
        $slider_instance_id = 'twssc-slider-' . $slider_id;
        
        ob_start();
        ?>
        <div id="<?php echo esc_attr($slider_instance_id); ?>" class="twssc-slider-container" 
            data-slides-to-show="<?php echo esc_attr($slides_to_show); ?>"
            data-fade-animation="<?php echo esc_attr($fade_animation); ?>"
            data-show-arrows="<?php echo esc_attr($show_arrows); ?>"
            data-show-dots="<?php echo esc_attr($show_dots); ?>"
            data-autoplay="<?php echo esc_attr($autoplay); ?>"
            data-pause-on-hover="<?php echo esc_attr($pause_on_hover); ?>"
            data-arrows-type="<?php echo esc_attr($custom_style['arrows_type'] ?? 'default'); ?>"
            data-custom-arrow-prev-url="<?php echo esc_url($custom_arrow_prev_url); ?>"
            data-custom-arrow-next-url="<?php echo esc_url($custom_arrow_next_url); ?>"
            data-arrows-position="<?php echo esc_attr($custom_style['arrows_position'] ?? 'center'); ?>">
            <div class="twssc-slider-main">
                <?php foreach ($images as $image_id): ?>
                    <?php 
                    $image_url = wp_get_attachment_image_url($image_id, 'large');
                    $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
                    if ($image_url):
                    ?>
                        <div class="twssc-slider-slide">
                            <img src="<?php echo esc_url($image_url); ?>" 
                                 alt="<?php echo esc_attr($image_alt ?: get_the_title($slider_id)); ?>"
                                 loading="lazy">
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
        
        return ob_get_clean();
    }
}