<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class TW_SIMPLE_SLIDER_Post_Type {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('init', array($this, 'register_post_type'));
        add_filter('manage_' . TW_SIMPLE_SLIDER_POST_TYPE . '_posts_columns', array($this, 'add_shortcode_column'));
        add_action('manage_' . TW_SIMPLE_SLIDER_POST_TYPE . '_posts_custom_column', array($this, 'display_shortcode_column'), 10, 2);
        add_filter('manage_edit-' . TW_SIMPLE_SLIDER_POST_TYPE . '_sortable_columns', array($this, 'make_shortcode_column_sortable'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_list_scripts'));
    }
    
    public function register_post_type() {
        $labels = array(
            'name'               => __('TW Sliders', 'tw-simple-slider'),
            'singular_name'      => __('TW Slider', 'tw-simple-slider'),
            'menu_name'          => __('TW Sliders', 'tw-simple-slider'),
            'add_new'            => __('Add New Slider', 'tw-simple-slider'),
            'add_new_item'       => __('Add New Slider', 'tw-simple-slider'),
            'edit_item'          => __('Edit Slider', 'tw-simple-slider'),
            'new_item'           => __('New Slider', 'tw-simple-slider'),
            'view_item'          => __('View Slider', 'tw-simple-slider'),
            'search_items'       => __('Search Sliders', 'tw-simple-slider'),
            'not_found'          => __('No sliders found', 'tw-simple-slider'),
            'not_found_in_trash' => __('No sliders found in Trash', 'tw-simple-slider'),
        );
        
        $args = array(
            'labels'              => $labels,
            'public'              => false,
            'publicly_queryable'  => false,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'query_var'           => true,
            'rewrite'             => false,
            'capability_type'     => 'post',
            'has_archive'         => false,
            'hierarchical'        => false,
            'menu_position'       => 20,
            'menu_icon'           => 'dashicons-images-alt2',
            'supports'            => array('title'),
            'show_in_rest'        => false,
        );
        
        register_post_type(TW_SIMPLE_SLIDER_POST_TYPE, $args);
    }
    
    public function enqueue_admin_list_scripts($hook) {
        // Only load on our post type list page
        if ('edit.php' !== $hook) {
            return;
        }
        
        // Verify we're on the correct post type using nonce for security
        $screen = get_current_screen();
        if (!$screen || TW_SIMPLE_SLIDER_POST_TYPE !== $screen->post_type) {
            return;
        }
        
        wp_enqueue_script(
            'twssc-slider-list-script',
            TW_SIMPLE_SLIDER_URL . 'assets/js/admin-list.js',
            array('jquery'),
            TW_SIMPLE_SLIDER_VERSION,
            array(
                'in_footer' => true,
                'strategy' => 'defer'
            )
        );
    }
    
    public function add_shortcode_column($columns) {
        $new_columns = array();
        
        foreach ($columns as $key => $value) {
            $new_columns[$key] = $value;
            
            if ($key === 'title') {
                $new_columns['shortcode'] = __('Shortcode', 'tw-simple-slider');
            }
        }
        
        if (!isset($new_columns['shortcode'])) {
            $new_columns['shortcode'] = __('Shortcode', 'tw-simple-slider');
        }
        
        return $new_columns;
    }
    
    public function display_shortcode_column($column, $post_id) {
        if ($column === 'shortcode') {
            $shortcode = '[twssc_slider id="' . $post_id . '"]';
            
            echo '<div class="twssc-shortcode-wrapper">';
            echo '<input type="text" readonly value="' . esc_attr($shortcode) . '" class="twssc-shortcode-field" data-slider-id="' . esc_attr($post_id) . '" title="' . esc_attr__('Click to select', 'tw-simple-slider') . '">';
            echo '</div>';
        }
    }
    
    public function make_shortcode_column_sortable($columns) {
        $columns['shortcode'] = 'shortcode';
        return $columns;
    }
}