jQuery(document).ready(function ($) {
    $('.twssc-slider-container').each(function () {
        const $container = $(this);
        const $slider = $container.find('.twssc-slider-main');
        
        if (!$slider.hasClass('slick-initialized')) {
            const slidesToShow = parseInt($container.data('slides-to-show')) || 1;
            const fadeAnimation = $container.data('fade-animation') === 'yes';
            const showArrows = $container.data('show-arrows') === 'yes';
            const showDots = $container.data('show-dots') === 'yes';
            const autoplay = $container.data('autoplay') === 'yes';
            const pauseOnHover = $container.data('pause-on-hover') === 'yes';
            const arrowsType = $container.data('arrows-type');
            const customArrowPrev = $container.data('custom-arrow-prev-url');
            const customArrowNext = $container.data('custom-arrow-next-url');
            const arrowsPosition = $container.data('arrows-position');
            
            const config = {
                slidesToShow: slidesToShow,
                slidesToScroll: 1,
                autoplay: autoplay,
                autoplaySpeed: 3000,
                pauseOnHover: pauseOnHover,
                arrows: showArrows,
                dots: showDots,
                fade: fadeAnimation && slidesToShow === 1,
                infinite: true,
                speed: 500,
                cssEase: 'linear',
                prevArrow: '<button type="button" class="slick-prev"><span class="slick-arrow-icon">←</span></button>',
                nextArrow: '<button type="button" class="slick-next"><span class="slick-arrow-icon">→</span></button>',
                responsive: [
                    {
                        breakpoint: 1024,
                        settings: {
                            slidesToShow: Math.min(slidesToShow, 3)
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: Math.min(slidesToShow, 2)
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1
                        }
                    }
                ]
            };
            
            $slider.slick(config);
            
            if (showArrows) {
                if (arrowsType === 'custom' && customArrowPrev && customArrowNext) {
                    setTimeout(function() {
                        const prevArrow = $container.find('.slick-prev');
                        const nextArrow = $container.find('.slick-next');
                        
                        prevArrow.css({
                            'background-image': 'url("' + customArrowPrev + '")',
                            'background-size': '50%',
                            'background-repeat': 'no-repeat',
                            'background-position': 'center'
                        });
                        
                        nextArrow.css({
                            'background-image': 'url("' + customArrowNext + '")',
                            'background-size': '50%',
                            'background-repeat': 'no-repeat',
                            'background-position': 'center'
                        });
                        
                        prevArrow.find('.slick-arrow-icon').hide();
                        nextArrow.find('.slick-arrow-icon').hide();
                    }, 300);
                }
                
                if (arrowsPosition && arrowsPosition !== 'center') {
                    setTimeout(function() {
                        const prevArrow = $container.find('.slick-prev');
                        const nextArrow = $container.find('.slick-next');
                        const arrowSize = 40;
                        const gap = 10;
                        
                        prevArrow.css({ top: '', right: '', bottom: '', left: '', transform: '' });
                        nextArrow.css({ top: '', right: '', bottom: '', left: '', transform: '' });
                        
                        switch(arrowsPosition) {
                            case 'top-left':
                                prevArrow.css({ top: '20px', left: '20px', transform: 'none' });
                                nextArrow.css({ top: '20px', left: (20 + arrowSize + gap) + 'px', right: 'auto', transform: 'none' });
                                break;
                            case 'top-center':
                                prevArrow.css({ top: '20px', left: 'calc(50% - ' + (arrowSize + gap/2) + 'px)', transform: 'none' });
                                nextArrow.css({ top: '20px', right: 'calc(50% - ' + (arrowSize + gap/2) + 'px)', transform: 'none' });
                                break;
                            case 'top-right':
                                prevArrow.css({ top: '20px', right: (20 + arrowSize + gap) + 'px', left: 'auto', transform: 'none' });
                                nextArrow.css({ top: '20px', right: '20px', transform: 'none' });
                                break;
                            case 'middle-left':
                                prevArrow.css({ left: '20px', top: 'calc(50% - ' + (arrowSize + gap) + 'px)', transform: 'none' });
                                nextArrow.css({ left: '20px', top: 'calc(50% + ' + gap + 'px)', transform: 'none' });
                                break;
                            case 'middle-right':
                                prevArrow.css({ right: '20px', left: 'auto', top: 'calc(50% - ' + (arrowSize + gap) + 'px)', transform: 'none' });
                                nextArrow.css({ right: '20px', left: 'auto', top: 'calc(50% + ' + gap + 'px)', transform: 'none' });
                                break;
                            case 'bottom-left':
                                prevArrow.css({ bottom: '20px', top: 'auto', left: '20px', transform: 'none' });
                                nextArrow.css({ bottom: '20px', top: 'auto', left: (20 + arrowSize + gap) + 'px', right: 'auto', transform: 'none' });
                                break;
                            case 'bottom-center':
                                prevArrow.css({ bottom: '20px', top: 'auto', left: 'calc(50% - ' + (arrowSize + gap/2) + 'px)', transform: 'none' });
                                nextArrow.css({ bottom: '20px', top: 'auto', right: 'calc(50% - ' + (arrowSize + gap/2) + 'px)', transform: 'none' });
                                break;
                            case 'bottom-right':
                                prevArrow.css({ bottom: '20px', top: 'auto', right: (20 + arrowSize + gap) + 'px', left: 'auto', transform: 'none' });
                                nextArrow.css({ bottom: '20px', top: 'auto', right: '20px', transform: 'none' });
                                break;
                        }
                    }, 300);
                }
            }
        }
    });
});