# TryMyLook Virtual Try-On WordPress Plugin

Transform your WooCommerce store with AI-powered virtual try-on technology. Allow customers to visualize how clothing and accessories look on them before making a purchase.

**Version:** 1.0.2 | **Requires:** WordPress 5.8+, WooCommerce 5.0+, PHP 7.4+

## Features

- 🎯 **One-Click Try-On**: Add a "Try On Me" button to any WooCommerce product page
- 📸 **Easy Upload**: Customers can upload their photo via drag & drop or file browser
- 🖼️ **Product Selection**: Choose from multiple product images/angles
- 🤖 **AI Generation**: Powered by TryMyLook's advanced AI technology
- 📥 **Download Results**: Optional download button for generated images
- ⚙️ **Customizable**: Configure button text and features from WordPress admin
- 📱 **Mobile Friendly**: Fully responsive design works on all devices
- ✅ **HPOS Compatible**: Fully compatible with WooCommerce High-Performance Order Storage

## Requirements

- **WordPress**: 5.8 or higher
- **PHP**: 7.4 or higher
- **WooCommerce**: 5.0 or higher (tested up to 9.0)
- **TryMyLook API Key**: Get one from [https://trymylook.app](https://trymylook.app)

## Installation

### Method 1: Upload via WordPress Admin

1. Download the plugin ZIP file
2. Go to WordPress Admin → Plugins → Add New
3. Click "Upload Plugin" at the top
4. Choose the downloaded ZIP file
5. Click "Install Now"
6. After installation, click "Activate Plugin"

### Method 2: Manual Installation

1. Download and extract the plugin ZIP file
2. Upload the `trymylook-virtual-try-on` folder to `/wp-content/plugins/`
3. Go to WordPress Admin → Plugins
4. Find "TryMyLook Virtual Try-On" and click "Activate"

## Configuration

### 1. Get Your API Key

1. Sign up at [https://trymylook.app](https://trymylook.app)
2. Go to your account dashboard
3. Navigate to API Settings or API Tokens
4. Generate a new API key for WordPress
5. Copy the API key

### 2. Configure the Plugin

1. Go to WordPress Admin → Settings → TryMyLook
2. Paste your API key in the "API Key" field
3. Customize button text (optional):
   - **Button Text**: Text shown on product pages (default: "Try On Me")
   - **Generate Button Text**: Text on the generate button (default: "Generate Try-On")
4. Enable/disable download button:
   - Check "Show Download Button" to allow customers to download results
5. Click "Save Changes"

### 3. Test the Integration

1. Go to any WooCommerce product page
2. You should see the "Try On Me" button below the Add to Cart button
3. Click the button to test the virtual try-on feature

## Usage

### For Store Owners

Once configured, the plugin automatically adds the "Try On Me" button to all WooCommerce product pages. No additional setup required!

**Customization Options:**
- Change button text to match your brand voice
- Enable/disable download functionality
- Control which products show the button (using WooCommerce product settings)

### For Customers

1. **Click "Try On Me"** on any product page
2. **Upload a photo** - Drag & drop or click to browse
3. **Select product view** - Choose the angle/image to try on
4. **Click "Generate Try-On"** - Wait 30-60 seconds for AI processing
5. **View result** - See how the product looks on you
6. **Download** (optional) - Save the image for later

## API Endpoints

The plugin communicates with these TryMyLook API endpoints:

### Generate Try-On
```
POST https://trymylook.app/api/v1/wordpress/generate
```

**Headers:**
- `X-API-Key: your_api_key`

**Parameters:**
- `user_image` (file): Customer's uploaded photo
- `product_image_url` (string): URL of the product image

**Response:**
```json
{
  "outfit_id": "123",
  "status": "pending",
  "status_url": "/api/v1/wordpress/status/123"
}
```

### Check Status
```
GET https://trymylook.app/api/v1/wordpress/status/{outfit_id}
```

**Headers:**
- `X-API-Key: your_api_key`

**Response:**
```json
{
  "status": "completed",
  "result_image_url": "https://trymylook.app/path/to/result.jpg"
}
```

**Status Values:**
- `pending`: Request received, queued for processing
- `processing`: AI generation in progress
- `completed`: Generation successful, image ready
- `failed`: Generation failed

## Troubleshooting

### Button Not Showing

**Problem**: "Try On Me" button doesn't appear on product pages

**Solutions:**
1. Make sure WooCommerce is activated
2. Verify the plugin is activated
3. Clear your site's cache (if using a caching plugin)
4. Check if your theme uses standard WooCommerce hooks

### API Key Errors

**Problem**: "Invalid API key" or "Unauthorized" errors

**Solutions:**
1. Double-check your API key in Settings → TryMyLook
2. Make sure there are no extra spaces before/after the key
3. Verify your API key is active on trymylook.app
4. Check if you've reached your generation limit

### Generation Fails

**Problem**: "Generation failed" error message

**Solutions:**
1. Check image file size (max 10MB)
2. Use clear, well-lit photos
3. Ensure product images are high quality
4. Verify your account has available generation credits

### Slow Performance

**Problem**: Generation takes too long or times out

**Solutions:**
1. Use smaller image files (under 5MB recommended)
2. Compress images before uploading
3. Check your internet connection
4. Try during off-peak hours

## Best Practices

### For Best Results

**Customer Photos:**
- Use well-lit, clear photos
- Face the camera directly
- Wear fitted clothing for accurate results
- Avoid busy backgrounds

**Product Images:**
- Use high-resolution images (at least 1000px)
- Show the product on a plain background
- Include multiple angles/views
- Ensure good lighting and color accuracy

### Security

- **Never share your API key publicly**
- Rotate API keys periodically
- Monitor usage in your TryMyLook dashboard
- Set appropriate generation limits

## Developer Hooks

### Filters

**Customize button position:**
```php
add_filter('trymylook_button_position', function($priority) {
    return 15; // Change priority (default: 10)
});
```

**Modify button HTML:**
```php
add_filter('trymylook_button_html', function($html, $button_text) {
    return '<button class="custom-class">' . $button_text . '</button>';
}, 10, 2);
```

**Change product images:**
```php
add_filter('trymylook_product_images', function($images, $product_id) {
    // Modify or filter product images array
    return $images;
}, 10, 2);
```

### Actions

**Before generation:**
```php
add_action('trymylook_before_generate', function($user_image, $product_image_url) {
    // Log or process before API call
}, 10, 2);
```

**After successful generation:**
```php
add_action('trymylook_generation_complete', function($outfit_id, $result_url) {
    // Track conversion, send notification, etc.
}, 10, 2);
```

## Support

- **Documentation**: [https://trymylook.app/docs](https://trymylook.app/docs)
- **Email**: support@trymylook.app
- **Issues**: Report bugs on GitHub

## Changelog

### Version 1.0.3 (2025-10-06)
- **Fixed**: File upload dialog no longer opens twice when clicking Browse Files button
- **Improved**: Better event handling to prevent event bubbling

### Version 1.0.2 (2025-10-05)
- **Fixed**: Now sends full-size product images to API instead of thumbnails
- **Improved**: Enhanced image URL detection with multiple fallback methods
- **Improved**: Added console logging for debugging image URLs
- **Enhancement**: Better compatibility with different WooCommerce themes and image configurations

### Version 1.0.1 (2025-10-05)
- **Fixed**: Added WooCommerce HPOS (High-Performance Order Storage) compatibility
- **Updated**: Declared compatibility with WooCommerce 9.0
- **Updated**: Added plugin dependency declaration for better WordPress integration
- **Improved**: Plugin now properly declares compatibility with modern WooCommerce features

### Version 1.0.0 (2024)
- Initial release
- WooCommerce integration
- Virtual try-on modal
- API communication
- Customizable settings
- Mobile responsive design

## License

This plugin is proprietary software. All rights reserved.

## Credits

Developed for TryMyLook - AI-Powered Virtual Try-On Technology

---

**Made with ❤️ for WooCommerce stores**
