<?php
/**
 * Webhooks settings tab – router: promotional upsell for free, Pro UI only when Pro build.
 *
 * @package TrustLens\Admin\Views\Settings
 * @since 1.1.0
 */

defined( 'ABSPATH' ) || exit;

$wstl_webhooks_upsell = array(
	__( 'Webhooks', 'trustlens' ),
	__( 'Integrate TrustLens with external systems like Slack, Zapier, or your own applications. Get real-time notifications when trust events occur.', 'trustlens' ),
	array(
		__( 'Send events to any HTTP endpoint', 'trustlens' ),
		__( 'HMAC-SHA256 signed payloads for security', 'trustlens' ),
		__( 'Filter by event type (score changes, blocks, orders)', 'trustlens' ),
		__( 'Delivery logs and one-click testing', 'trustlens' ),
	),
);

if ( ! wstl_has_webhooks() || wstl_is_free_user() ) {
	wstl_render_pro_upsell(
		$wstl_webhooks_upsell[0],
		$wstl_webhooks_upsell[1],
		$wstl_webhooks_upsell[2],
		array(
			array( __( 'Outbound integrations', 'trustlens' ), __( 'Not available', 'trustlens' ), __( 'Any HTTP endpoint', 'trustlens' ) ),
			array( __( 'Security', 'trustlens' ), __( 'N/A', 'trustlens' ), __( 'HMAC-SHA256 signatures', 'trustlens' ) ),
			array( __( 'Visibility', 'trustlens' ), __( 'N/A', 'trustlens' ), __( 'Delivery logs + test tools', 'trustlens' ) ),
		),
		__( 'Connect TrustLens', 'trustlens' )
	);
	return;
}

$webhooks_pro = TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/webhooks-pro.php';
if ( file_exists( $webhooks_pro ) ) {
	include $webhooks_pro;
} else {
	wstl_render_pro_upsell(
		$wstl_webhooks_upsell[0],
		$wstl_webhooks_upsell[1],
		$wstl_webhooks_upsell[2],
		array(
			array( __( 'Outbound integrations', 'trustlens' ), __( 'Not available', 'trustlens' ), __( 'Any HTTP endpoint', 'trustlens' ) ),
			array( __( 'Security', 'trustlens' ), __( 'N/A', 'trustlens' ), __( 'HMAC-SHA256 signatures', 'trustlens' ) ),
			array( __( 'Visibility', 'trustlens' ), __( 'N/A', 'trustlens' ), __( 'Delivery logs + test tools', 'trustlens' ) ),
		),
		__( 'Connect TrustLens', 'trustlens' )
	);
}
