<?php
/**
 * Reports settings tab – router: promotional upsell for free, Pro UI only when Pro build.
 *
 * @package TrustLens\Admin\Views\Settings
 * @since 1.1.0
 */

defined( 'ABSPATH' ) || exit;

$wstl_reports_upsell = array(
	__( 'Scheduled Reports', 'trustlens' ),
	__( 'Receive automated trust intelligence reports via email. Stay informed about customer risk trends without logging in.', 'trustlens' ),
	array(
		__( 'Daily, weekly, or monthly report schedules', 'trustlens' ),
		__( 'Summary, high-risk, segment changes, and trends reports', 'trustlens' ),
		__( 'Multiple recipients supported', 'trustlens' ),
		__( 'Send reports on demand with one click', 'trustlens' ),
	),
);

if ( ! wstl_has_scheduled_reports() || wstl_is_free_user() ) {
	wstl_render_pro_upsell(
		$wstl_reports_upsell[0],
		$wstl_reports_upsell[1],
		$wstl_reports_upsell[2],
		array(
			array( __( 'Report delivery', 'trustlens' ), __( 'In-dashboard only', 'trustlens' ), __( 'Email schedules + send now', 'trustlens' ) ),
			array( __( 'Cadence', 'trustlens' ), __( 'Manual checks', 'trustlens' ), __( 'Daily, weekly, monthly', 'trustlens' ) ),
			array( __( 'Coverage', 'trustlens' ), __( 'Basic dashboard view', 'trustlens' ), __( 'Summary, trends, risk, segment changes', 'trustlens' ) ),
		),
		__( 'Automate Reporting', 'trustlens' )
	);
	return;
}

$reports_pro = TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/reports-pro.php';
if ( file_exists( $reports_pro ) ) {
	include $reports_pro;
} else {
	wstl_render_pro_upsell(
		$wstl_reports_upsell[0],
		$wstl_reports_upsell[1],
		$wstl_reports_upsell[2],
		array(
			array( __( 'Report delivery', 'trustlens' ), __( 'In-dashboard only', 'trustlens' ), __( 'Email schedules + send now', 'trustlens' ) ),
			array( __( 'Cadence', 'trustlens' ), __( 'Manual checks', 'trustlens' ), __( 'Daily, weekly, monthly', 'trustlens' ) ),
			array( __( 'Coverage', 'trustlens' ), __( 'Basic dashboard view', 'trustlens' ), __( 'Summary, trends, risk, segment changes', 'trustlens' ) ),
		),
		__( 'Automate Reporting', 'trustlens' )
	);
}
