<?php
/**
 * Payment controls settings tab.
 *
 * @package TrustLens\Admin\Views\Settings
 * @since   1.0.6
 */

defined( 'ABSPATH' ) || exit;
?>

<?php if ( wstl_has_payment_method_controls() && wstl_can_use_pro() ) : ?>
<?php
	$selected_segments = get_option( 'trustlens_payment_method_control_segments', array( 'risk', 'critical' ) );
	if ( ! is_array( $selected_segments ) ) {
		$selected_segments = array( 'risk', 'critical' );
	}
	$selected_gateways = get_option( 'trustlens_payment_method_control_gateways', array() );
	if ( ! is_array( $selected_gateways ) ) {
		$selected_gateways = array();
	}
	$velocity_enabled = (bool) get_option( 'trustlens_payment_method_control_velocity_enabled', false );
	$velocity_count   = (int) get_option( 'trustlens_payment_method_control_velocity_count', 3 );
	$velocity_hours   = (int) get_option( 'trustlens_payment_method_control_velocity_hours', 24 );
	$linked_risk_enabled = (bool) get_option( 'trustlens_payment_method_control_linked_risk_enabled', false );
	$segment_labels = array(
		'risk'     => __( 'Risk', 'trustlens' ),
		'critical' => __( 'Critical', 'trustlens' ),
		'caution'  => __( 'Caution', 'trustlens' ),
		'normal'   => __( 'Normal', 'trustlens' ),
		'trusted'  => __( 'Trusted', 'trustlens' ),
		'vip'      => __( 'VIP', 'trustlens' ),
	);
	$payment_gateways = array();
	if ( class_exists( 'WC_Payment_Gateways' ) ) {
		foreach ( WC_Payment_Gateways::instance()->payment_gateways() as $gateway ) {
			if ( isset( $gateway->id ) ) {
				$payment_gateways[ sanitize_key( (string) $gateway->id ) ] = (string) $gateway->get_title();
			}
		}
	}
?>
<form method="post" action="options.php">
	<?php settings_fields( 'trustlens_settings' ); ?>

	<div class="wstl-card">
		<h2><?php esc_html_e( 'Payment Method Risk Controls', 'trustlens' ); ?> <?php echo wp_kses_post( wstl_pro_badge( false ) ); ?></h2>

		<table class="form-table">
			<tr>
				<th scope="row"><?php esc_html_e( 'Enable Controls', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_enable_payment_method_controls" value="0">
						<input type="checkbox" name="trustlens_enable_payment_method_controls" value="1" <?php checked( get_option( 'trustlens_enable_payment_method_controls', false ) ); ?>>
						<?php esc_html_e( 'Restrict selected payment methods for risky customer segments', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'When enabled, TrustLens will hide selected gateways on checkout for customers in the segments below.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Apply to Segments', 'trustlens' ); ?></th>
				<td>
					<?php foreach ( $segment_labels as $segment_key => $segment_label ) : ?>
						<label>
							<input type="checkbox" name="trustlens_payment_method_control_segments[]" value="<?php echo esc_attr( $segment_key ); ?>" <?php checked( in_array( $segment_key, $selected_segments, true ) ); ?>>
							<?php echo esc_html( $segment_label ); ?>
						</label>
					<?php endforeach; ?>
					<p class="description">
						<?php esc_html_e( 'Recommended: Risk and Critical only.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="trustlens_payment_method_control_gateways"><?php esc_html_e( 'Restricted Gateways', 'trustlens' ); ?></label>
				</th>
				<td>
					<?php if ( ! empty( $payment_gateways ) ) : ?>
						<select id="trustlens_payment_method_control_gateways" name="trustlens_payment_method_control_gateways[]" multiple size="6">
							<?php foreach ( $payment_gateways as $gateway_id => $gateway_title ) : ?>
								<option value="<?php echo esc_attr( $gateway_id ); ?>" <?php selected( in_array( $gateway_id, $selected_gateways, true ) ); ?>>
									<?php echo esc_html( $gateway_title ); ?> (<?php echo esc_html( $gateway_id ); ?>)
								</option>
							<?php endforeach; ?>
						</select>
						<p class="description">
							<?php esc_html_e( 'Hold Ctrl/Cmd to select multiple gateways to hide.', 'trustlens' ); ?>
						</p>
					<?php else : ?>
						<p class="description"><?php esc_html_e( 'No payment gateways found.', 'trustlens' ); ?></p>
					<?php endif; ?>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="trustlens_payment_method_control_min_total"><?php esc_html_e( 'Minimum Order Total', 'trustlens' ); ?></label>
				</th>
				<td>
					<input type="number" id="trustlens_payment_method_control_min_total" name="trustlens_payment_method_control_min_total" value="<?php echo esc_attr( get_option( 'trustlens_payment_method_control_min_total', 0 ) ); ?>" min="0" step="0.01" class="small-text">
					<p class="description">
						<?php esc_html_e( 'Only apply restrictions when order total is at or above this amount. Use 0 to apply at any amount.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="trustlens_payment_method_control_message"><?php esc_html_e( 'Checkout Message', 'trustlens' ); ?></label>
				</th>
				<td>
					<textarea id="trustlens_payment_method_control_message" name="trustlens_payment_method_control_message" rows="3" class="large-text"><?php echo esc_textarea( get_option( 'trustlens_payment_method_control_message', __( 'Some payment methods are unavailable for this order. Please choose another payment option.', 'trustlens' ) ) ); ?></textarea>
					<p class="description">
						<?php esc_html_e( 'Message shown when payment options are restricted.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Velocity Protection', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_payment_method_control_velocity_enabled" value="0">
						<input type="checkbox" name="trustlens_payment_method_control_velocity_enabled" value="1" <?php checked( $velocity_enabled ); ?>>
						<?php esc_html_e( 'Temporarily restrict selected gateways when order velocity is high', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'If enabled, payment methods above will be hidden when a customer places too many orders in a short window.', 'trustlens' ); ?>
					</p>
					<p>
						<label for="trustlens_payment_method_control_velocity_count"><?php esc_html_e( 'Max orders:', 'trustlens' ); ?></label>
						<input type="number" id="trustlens_payment_method_control_velocity_count" name="trustlens_payment_method_control_velocity_count" value="<?php echo esc_attr( $velocity_count ); ?>" min="2" max="50" class="small-text">
						<label for="trustlens_payment_method_control_velocity_hours"><?php esc_html_e( 'within hours:', 'trustlens' ); ?></label>
						<input type="number" id="trustlens_payment_method_control_velocity_hours" name="trustlens_payment_method_control_velocity_hours" value="<?php echo esc_attr( $velocity_hours ); ?>" min="1" max="168" class="small-text">
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Linked Account Protection', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_payment_method_control_linked_risk_enabled" value="0">
						<input type="checkbox" name="trustlens_payment_method_control_linked_risk_enabled" value="1" <?php checked( $linked_risk_enabled ); ?>>
						<?php esc_html_e( 'Restrict selected gateways when this checkout is linked to risky accounts', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'Uses linked-account fingerprints (address, phone, IP, device) to detect abusive account networks in real time.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
		</table>
	</div>

	<?php submit_button(); ?>
</form>
<?php elseif ( wstl_show_pro_upsells() ) : ?>
<?php
	wstl_render_pro_upsell(
		__( 'Payment Method Risk Controls', 'trustlens' ),
		__( 'Hide selected payment methods for high-risk checkout sessions to reduce chargeback and fraud exposure.', 'trustlens' ),
		array(
			__( 'Restrict risky segments from high-exposure gateways', 'trustlens' ),
			__( 'Configure gateway-specific policies with order amount thresholds', 'trustlens' ),
			__( 'Auto-trigger temporary gateway lock on velocity spikes', 'trustlens' ),
			__( 'Detect linked risky accounts by fingerprint and restrict gateways', 'trustlens' ),
			__( 'Log restriction events for review and automation', 'trustlens' ),
		),
		array(
			array( __( 'Gateway-level risk policy', 'trustlens' ), __( 'Not available', 'trustlens' ), __( 'Included', 'trustlens' ) ),
			array( __( 'Segment-aware checkout controls', 'trustlens' ), __( 'Not available', 'trustlens' ), __( 'Included', 'trustlens' ) ),
			array( __( 'Restriction event logging', 'trustlens' ), __( 'Limited', 'trustlens' ), __( 'Included', 'trustlens' ) ),
		),
		__( 'Available in Pro', 'trustlens' ),
		__( 'Reduce checkout risk without blocking every order.', 'trustlens' )
	);
?>
<?php endif; ?>
