<?php
/**
 * Modules settings tab.
 *
 * @package TrustLens\Admin\Views\Settings
 * @since   1.0.0
 */

defined( 'ABSPATH' ) || exit;
?>

<form method="post" action="options.php">
	<?php settings_fields( 'trustlens_settings' ); ?>

	<!-- Detection Modules -->
	<div class="wstl-card">
		<h2><?php esc_html_e( 'Detection Modules', 'trustlens' ); ?></h2>
		<p class="description wstl-mb-20">
			<?php esc_html_e( 'Enable or disable individual detection modules to customize how customer trust scores are calculated.', 'trustlens' ); ?>
		</p>

		<table class="form-table">
			<tr>
				<th scope="row"><?php esc_html_e( 'Return Abuse Detection', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_module_returns_enabled" value="0">
						<input type="checkbox" name="trustlens_module_returns_enabled" value="1" <?php checked( get_option( 'trustlens_module_returns_enabled', true ) ); ?>>
						<?php esc_html_e( 'Track return patterns and identify serial returners', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'Analyzes refund rates, refund values, and return patterns to identify potential abuse.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Order Tracking', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_module_orders_enabled" value="0">
						<input type="checkbox" name="trustlens_module_orders_enabled" value="1" <?php checked( get_option( 'trustlens_module_orders_enabled', true ) ); ?>>
						<?php esc_html_e( 'Track order activity and cancellation patterns', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'Monitors order completion rates, cancellations, and order frequency.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Coupon Abuse Detection', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_module_coupons_enabled" value="0">
						<input type="checkbox" name="trustlens_module_coupons_enabled" value="1" <?php checked( get_option( 'trustlens_module_coupons_enabled', true ) ); ?>>
						<?php esc_html_e( 'Detect coupon abuse patterns', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'Identifies customers who abuse first-order discounts by using them repeatedly or refunding coupon orders.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="trustlens_coupons_max_first_order"><?php esc_html_e( 'Max first-order coupons', 'trustlens' ); ?></label>
				</th>
				<td>
					<input type="number" id="trustlens_coupons_max_first_order" name="trustlens_coupons_max_first_order" value="<?php echo esc_attr( get_option( 'trustlens_coupons_max_first_order', 2 ) ); ?>" min="1" max="20" step="1" class="small-text">
					<?php esc_html_e( 'before flagging as abuse', 'trustlens' ); ?>
					<p class="description">
						<?php esc_html_e( 'Maximum times a customer can use first-order coupons before being flagged for abuse.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<?php if ( wstl_can_use_pro() ) : ?>
			<tr>
				<th scope="row"><?php esc_html_e( 'Block linked account abuse', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_coupons_block_linked_abuse" value="0">
						<input type="checkbox" name="trustlens_coupons_block_linked_abuse" value="1" <?php checked( get_option( 'trustlens_coupons_block_linked_abuse', false ) ); ?>>
						<?php esc_html_e( 'Block checkout if first-order coupon used on a linked account', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'When enabled, customers whose linked accounts have used first-order coupons will not be able to use similar coupons at checkout.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<?php elseif ( wstl_show_pro_upsells() ) : ?>
			<tr>
				<th scope="row"><?php esc_html_e( 'Block linked account abuse', 'trustlens' ); ?></th>
				<td>
					<p class="description">
						<?php esc_html_e( 'Block checkout when a linked account has used first-order coupons.', 'trustlens' ); ?>
						<?php echo wp_kses_post( wstl_pro_badge( true ) ); ?>
					</p>
				</td>
			</tr>
			<?php endif; ?>
			<tr>
				<th scope="row"><?php esc_html_e( 'Category-Aware Scoring', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_module_categories_enabled" value="0">
						<input type="checkbox" name="trustlens_module_categories_enabled" value="1" <?php checked( get_option( 'trustlens_module_categories_enabled', true ) ); ?>>
						<?php esc_html_e( 'Apply different weights to returns based on product category risk', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'Tracks per-category return rates and applies heavier penalties for high-risk categories.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
		</table>
	</div>

	<!-- Linked Accounts -->
	<div class="wstl-card">
		<h2><?php esc_html_e( 'Linked Accounts Detection', 'trustlens' ); ?></h2>
		<p class="description wstl-mb-20">
			<?php esc_html_e( 'Detect when the same person uses multiple accounts and apply a configurable score penalty.', 'trustlens' ); ?>
		</p>

		<table class="form-table">
			<tr>
				<th scope="row"><?php esc_html_e( 'Enable Detection', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_module_linked_accounts_enabled" value="0">
						<input type="checkbox" name="trustlens_module_linked_accounts_enabled" value="1" <?php checked( get_option( 'trustlens_module_linked_accounts_enabled', true ) ); ?>>
						<?php esc_html_e( 'Detect linked accounts via device fingerprinting', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'Uses device fingerprints and IP addresses to identify customers using multiple accounts.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="trustlens_linked_accounts_penalty"><?php esc_html_e( 'Link Penalty', 'trustlens' ); ?></label>
				</th>
				<td>
					<input type="number" id="trustlens_linked_accounts_penalty" name="trustlens_linked_accounts_penalty" value="<?php echo esc_attr( get_option( 'trustlens_linked_accounts_penalty', 5 ) ); ?>" min="0" max="20" step="1" class="small-text">
					<?php esc_html_e( 'points per linked high-risk account', 'trustlens' ); ?>
					<p class="description">
						<?php esc_html_e( 'Score penalty applied for each high-risk or blocked linked account.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
		</table>
	</div>

	<?php submit_button(); ?>
</form>
