<?php
/**
 * General settings tab.
 *
 * @package TrustLens\Admin\Views\Settings
 * @since   1.0.0
 */

defined( 'ABSPATH' ) || exit;
?>

<form method="post" action="options.php">
	<?php settings_fields( 'trustlens_settings' ); ?>

	<!-- General Settings -->
	<div class="wstl-card">
		<h2><?php esc_html_e( 'General Settings', 'trustlens' ); ?></h2>

		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="trustlens_min_orders"><?php esc_html_e( 'Minimum Orders for Scoring', 'trustlens' ); ?></label>
				</th>
				<td>
					<input type="number" id="trustlens_min_orders" name="trustlens_min_orders" value="<?php echo esc_attr( get_option( 'trustlens_min_orders', 3 ) ); ?>" min="1" max="20" class="small-text">
					<p class="description">
						<?php esc_html_e( 'Customers with fewer orders will show as "Normal" until they reach this threshold.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Dashboard Integration', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_enable_dashboard" value="0">
						<input type="checkbox" name="trustlens_enable_dashboard" value="1" <?php checked( get_option( 'trustlens_enable_dashboard', true ) ); ?>>
						<?php esc_html_e( 'Show TrustLens widget on WordPress dashboard', 'trustlens' ); ?>
					</label>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Order Warnings', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_enable_order_warning" value="0">
						<input type="checkbox" name="trustlens_enable_order_warning" value="1" <?php checked( get_option( 'trustlens_enable_order_warning', true ) ); ?>>
						<?php esc_html_e( 'Show customer trust info on order edit screen', 'trustlens' ); ?>
					</label>
				</td>
			</tr>
		</table>
	</div>

	<!-- Risk Thresholds -->
	<div class="wstl-card">
		<h2><?php esc_html_e( 'Return Rate Thresholds', 'trustlens' ); ?></h2>

		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="trustlens_returns_high_threshold"><?php esc_html_e( 'High Risk Threshold', 'trustlens' ); ?></label>
				</th>
				<td>
					<input type="number" id="trustlens_returns_high_threshold" name="trustlens_returns_high_threshold" value="<?php echo esc_attr( get_option( 'trustlens_returns_high_threshold', 40 ) ); ?>" min="10" max="90" class="small-text">%
					<p class="description">
						<?php esc_html_e( 'Return rate percentage to consider a customer high risk.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="trustlens_returns_critical_threshold"><?php esc_html_e( 'Critical Risk Threshold', 'trustlens' ); ?></label>
				</th>
				<td>
					<input type="number" id="trustlens_returns_critical_threshold" name="trustlens_returns_critical_threshold" value="<?php echo esc_attr( get_option( 'trustlens_returns_critical_threshold', 60 ) ); ?>" min="20" max="100" class="small-text">%
					<p class="description">
						<?php esc_html_e( 'Return rate percentage to consider a customer critical risk.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
		</table>
	</div>

	<!-- Blocking Settings -->
	<div class="wstl-card">
		<h2><?php esc_html_e( 'Blocking Settings', 'trustlens' ); ?></h2>

		<table class="form-table">
			<tr>
				<th scope="row"><?php esc_html_e( 'Enable Blocking', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_enable_blocking" value="0">
						<input type="checkbox" name="trustlens_enable_blocking" value="1" <?php checked( get_option( 'trustlens_enable_blocking', false ) ); ?>>
						<?php esc_html_e( 'Allow blocking customers from checkout', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'When enabled, blocked customers will not be able to complete checkout. Blocking is always manual - customers are never auto-blocked.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="trustlens_block_message"><?php esc_html_e( 'Block Message', 'trustlens' ); ?></label>
				</th>
				<td>
					<textarea id="trustlens_block_message" name="trustlens_block_message" rows="3" class="large-text"><?php echo esc_textarea( get_option( 'trustlens_block_message', __( 'We are unable to process your order at this time. Please contact support for assistance.', 'trustlens' ) ) ); ?></textarea>
					<p class="description">
						<?php esc_html_e( 'Message shown to blocked customers at checkout.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
		</table>
	</div>

	<p class="description" style="margin-top: 1em;">
		<?php
		printf(
			/* translators: %s: link to notifications page */
			esc_html__( 'Email notification settings are on the %s page.', 'trustlens' ),
			'<a href="' . esc_url( admin_url( 'admin.php?page=trustlens-notifications' ) ) . '">' . esc_html__( 'Notifications', 'trustlens' ) . '</a>'
		);
		?>
	</p>

	<?php submit_button(); ?>
</form>
