<?php
/**
 * Data management settings tab.
 *
 * @package TrustLens\Admin\Views\Settings
 * @since   1.0.0
 */

defined( 'ABSPATH' ) || exit;

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to included view file.

// Get sync status.
$sync = TrustLens_Historical_Sync::instance();
$sync_status = $sync->get_status();
$progress = $sync->get_progress();

// Get data statistics.
global $wpdb;
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Simple count query, table name from $wpdb->prefix is safe.
$customer_count = $wpdb->get_var( "SELECT COUNT(*) FROM {$wpdb->prefix}trustlens_customers" );
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$events_count = $wpdb->get_var( "SELECT COUNT(*) FROM {$wpdb->prefix}trustlens_events" );
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$signals_count = $wpdb->get_var( "SELECT COUNT(*) FROM {$wpdb->prefix}trustlens_signals" );
?>

<div class="wstl-card">
	<h2><?php esc_html_e( 'Historical Data Sync', 'trustlens' ); ?></h2>

	<div id="wstl-sync-status" class="wstl-sync-status">
		<p>
			<strong><?php esc_html_e( 'Status:', 'trustlens' ); ?></strong>
			<span class="wstl-sync-status-text">
				<?php
				switch ( $sync_status['status'] ) {
					case 'running':
						esc_html_e( 'Running', 'trustlens' );
						break;
					case 'complete':
						esc_html_e( 'Complete', 'trustlens' );
						break;
					case 'stopped':
						esc_html_e( 'Stopped', 'trustlens' );
						break;
					default:
						esc_html_e( 'Not Started', 'trustlens' );
				}
				?>
			</span>
		</p>

		<?php
		$sync_running = 'running' === $sync_status['status'];
		$sync_progress_val = $sync_running ? ( $progress ) : 0;
		$sync_processed = $sync_status['processed'] ?? 0;
		$sync_total = $sync_status['total'] ?? 0;
		?>
		<div id="wstl-sync-progress-area" class="<?php echo $sync_running ? '' : 'wstl-modal-hidden'; ?>">
			<div class="wstl-progress-bar">
				<div class="wstl-progress-fill" style="width: <?php echo esc_attr( $sync_progress_val ); ?>%;"></div>
			</div>
			<p class="wstl-progress-text" id="wstl-sync-orders-text">
				<?php
				echo esc_html(
					sprintf(
						/* translators: %1$d: processed, %2$d: total, %3$s: percentage */
						__( 'Processed %1$d of %2$d orders (%3$s%%)', 'trustlens' ),
						$sync_processed,
						$sync_total,
						number_format( $sync_progress_val, 1 )
					)
				);
				?>
			</p>
		</div>

		<?php if ( ! empty( $sync_status['last_run'] ) ) : ?>
			<p class="description">
				<?php
				printf(
					/* translators: %s: date/time */
					esc_html__( 'Last run: %s', 'trustlens' ),
					esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $sync_status['last_run'] ) ) )
				);
				?>
			</p>
		<?php endif; ?>
	</div>

	<p class="wstl-mt-20">
		<button type="button" class="button button-primary" id="wstl-start-sync" <?php echo $sync_running ? ' style="display:none;"' : ''; ?>>
			<?php esc_html_e( 'Start Historical Sync', 'trustlens' ); ?>
		</button>
		<button type="button" class="button" id="wstl-stop-sync" <?php echo $sync_running ? '' : ' style="display:none;"'; ?>>
			<?php esc_html_e( 'Stop Sync', 'trustlens' ); ?>
		</button>
		<span class="spinner wstl-spinner-inline"></span>
	</p>

	<p class="description">
		<?php esc_html_e( 'Sync analyzes your existing WooCommerce orders to build customer trust profiles. This runs in the background and may take some time for large stores.', 'trustlens' ); ?>
	</p>
</div>

<?php
// Test data seeder (stripped from production builds).
if ( class_exists( 'TrustLens_Test_Data_Seeder' ) ) :
$seeder = TrustLens_Test_Data_Seeder::instance();
$has_test_data = $seeder->has_test_data();
$test_data_count = $has_test_data ? $seeder->get_test_data_count() : 0;
?>

<div class="wstl-card wstl-card-dev">
	<h2><?php esc_html_e( 'Test Data (Development)', 'trustlens' ); ?></h2>
	<p class="description wstl-mb-15">
		<?php esc_html_e( 'Generate sample customer data across all trust segments to test plugin functionality without real WooCommerce orders.', 'trustlens' ); ?>
	</p>

	<div id="wstl-test-data-status">
		<?php if ( $has_test_data ) : ?>
			<p>
				<span class="dashicons dashicons-yes-alt wstl-icon-success"></span>
				<?php
				printf(
					/* translators: %d: number of test customers */
					esc_html__( '%d test customers currently in database.', 'trustlens' ),
					absint( $test_data_count )
				);
				?>
			</p>
		<?php else : ?>
			<p>
				<span class="dashicons dashicons-info wstl-icon-info"></span>
				<?php esc_html_e( 'No test data. Click below to generate 60 sample customers across all segments.', 'trustlens' ); ?>
			</p>
		<?php endif; ?>
	</div>

	<p class="wstl-mt-15">
		<?php if ( $has_test_data ) : ?>
			<button type="button" class="button button-link-delete" id="wstl-remove-test-data">
				<?php esc_html_e( 'Remove Test Data', 'trustlens' ); ?>
			</button>
		<?php else : ?>
			<button type="button" class="button button-primary" id="wstl-seed-test-data">
				<?php esc_html_e( 'Generate Test Data', 'trustlens' ); ?>
			</button>
		<?php endif; ?>
		<span class="spinner wstl-spinner-inline" id="wstl-test-data-spinner"></span>
	</p>

	<div id="wstl-test-data-result" class="wstl-mt-10"></div>

	<p class="description wstl-mt-15">
		<?php esc_html_e( 'Test data includes:', 'trustlens' ); ?>
	</p>
	<ul class="wstl-list-disc">
		<li><?php esc_html_e( '40 VIP customers (score ~90)', 'trustlens' ); ?></li>
		<li><?php esc_html_e( '15 Trusted customers (score ~85)', 'trustlens' ); ?></li>
		<li><?php esc_html_e( '3 Normal customers (score ~65)', 'trustlens' ); ?></li>
		<li><?php esc_html_e( '1 Risk customer (score ~15)', 'trustlens' ); ?></li>
		<li><?php esc_html_e( '1 Critical customer (score ~0)', 'trustlens' ); ?></li>
		<li><?php esc_html_e( 'Includes blocked customers', 'trustlens' ); ?></li>
	</ul>
</div>
<?php endif; ?>

<div class="wstl-card">
	<h2><?php esc_html_e( 'Data Statistics', 'trustlens' ); ?></h2>

	<table class="form-table">
		<tr>
			<th scope="row"><?php esc_html_e( 'Customers', 'trustlens' ); ?></th>
			<td><strong><?php echo esc_html( number_format( $customer_count ) ); ?></strong></td>
		</tr>
		<tr>
			<th scope="row"><?php esc_html_e( 'Events Logged', 'trustlens' ); ?></th>
			<td><strong><?php echo esc_html( number_format( $events_count ) ); ?></strong></td>
		</tr>
		<tr>
			<th scope="row"><?php esc_html_e( 'Signals Recorded', 'trustlens' ); ?></th>
			<td><strong><?php echo esc_html( number_format( $signals_count ) ); ?></strong></td>
		</tr>
	</table>
</div>

<form method="post" action="options.php">
	<?php settings_fields( 'trustlens_settings' ); ?>

	<div class="wstl-card">
		<h2><?php esc_html_e( 'Data Management', 'trustlens' ); ?></h2>

		<table class="form-table">
			<tr>
				<th scope="row"><?php esc_html_e( 'Uninstall Behavior', 'trustlens' ); ?></th>
				<td>
					<label>
						<input type="hidden" name="trustlens_remove_data_on_uninstall" value="0">
						<input type="checkbox" name="trustlens_remove_data_on_uninstall" value="1" <?php checked( get_option( 'trustlens_remove_data_on_uninstall', false ) ); ?>>
						<?php esc_html_e( 'Remove all TrustLens data when plugin is deleted', 'trustlens' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'Warning: This will permanently delete all customer trust data, events, and signals when the plugin is uninstalled.', 'trustlens' ); ?>
					</p>
				</td>
			</tr>
		</table>

		<?php submit_button(); ?>
	</div>
</form>

<div class="wstl-card wstl-card-danger">
	<h2><?php esc_html_e( 'Danger Zone', 'trustlens' ); ?></h2>

	<table class="form-table">
		<tr>
			<th scope="row"><?php esc_html_e( 'Reset All Data', 'trustlens' ); ?></th>
			<td>
				<button type="button" class="button button-link-delete" id="wstl-reset-data">
					<?php esc_html_e( 'Delete All TrustLens Data', 'trustlens' ); ?>
				</button>
				<p class="description">
					<?php esc_html_e( 'This will permanently delete all customer trust data, events, signals, and reset the sync status. This action cannot be undone.', 'trustlens' ); ?>
				</p>
			</td>
		</tr>
	</table>
</div>

<?php // phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound ?>
