<?php
/**
 * Chargebacks settings tab.
 * Shows Pro upsell when Chargebacks module is not in the build (e.g. free version).
 *
 * @package TrustLens\Admin\Views\Settings
 * @since   1.2.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! wstl_has_chargebacks() || wstl_is_free_user() ) {
	wstl_render_pro_upsell(
		__( 'Chargeback Tracking', 'trustlens' ),
		__( 'Track disputes and chargebacks from Stripe, WooPayments, or manual entry. See which customers have filed disputes, record wins and losses, and factor chargeback history into trust scores.', 'trustlens' ),
		array(
			__( 'Record chargebacks and disputes per customer', 'trustlens' ),
			__( 'Track dispute outcomes (won, lost, pending)', 'trustlens' ),
			__( 'Chargeback history affects trust score and segments', 'trustlens' ),
			__( 'Integrate with Stripe and WooPayments dispute data', 'trustlens' ),
		),
		array(
			array( __( 'Dispute visibility', 'trustlens' ), __( 'Not available', 'trustlens' ), __( 'Per-customer tracking', 'trustlens' ) ),
			array( __( 'Outcome analytics', 'trustlens' ), __( 'N/A', 'trustlens' ), __( 'Won / lost / pending insights', 'trustlens' ) ),
			array( __( 'Score impact', 'trustlens' ), __( 'No chargeback signal', 'trustlens' ), __( 'Built into trust scoring', 'trustlens' ) ),
		),
		__( 'Protect Revenue', 'trustlens' )
	);
	return;
}

// Pro build: include the actual Chargebacks settings view if it exists; otherwise show a short message.
$chargebacks_view = TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/chargebacks-pro.php';
if ( file_exists( $chargebacks_view ) ) {
	include $chargebacks_view;
} else {
	echo '<div class="wstl-card"><p class="description">' . esc_html__( 'Chargeback tracking is active. View dispute stats in the Dashboard.', 'trustlens' ) . '</p></div>';
}
