<?php
/**
 * API settings tab.
 *
 * @package TrustLens\Admin\Views\Settings
 * @since   1.0.0
 */

defined( 'ABSPATH' ) || exit;

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to included view file.

$api_key = get_option( 'trustlens_api_key', '' );
?>

<div class="wstl-card">
	<h2><?php esc_html_e( 'REST API', 'trustlens' ); ?></h2>

	<table class="form-table">
		<tr>
			<th scope="row">
				<label for="trustlens_api_key"><?php esc_html_e( 'API Key', 'trustlens' ); ?></label>
			</th>
			<td>
				<?php if ( empty( $api_key ) ) : ?>
					<p class="description">
						<?php esc_html_e( 'No API key generated. Click below to generate one.', 'trustlens' ); ?>
					</p>
					<button type="button" class="button" id="wstl-generate-api-key">
						<?php esc_html_e( 'Generate API Key', 'trustlens' ); ?>
					</button>
				<?php else : ?>
					<input type="text" id="trustlens_api_key" value="" class="regular-text" readonly placeholder="<?php echo esc_attr__( 'Key is set (copy it when you generate or regenerate)', 'trustlens' ); ?>">
					<button type="button" class="button" id="wstl-regenerate-api-key">
						<?php esc_html_e( 'Regenerate', 'trustlens' ); ?>
					</button>
					<p class="description">
						<?php esc_html_e( 'API key is set. Use the X-TrustLens-API-Key header with the key you copied when you generated it. Regenerate to create a new key (the current key will stop working).', 'trustlens' ); ?>
					</p>
				<?php endif; ?>
			</td>
		</tr>
		<tr>
			<th scope="row"><?php esc_html_e( 'API Endpoint', 'trustlens' ); ?></th>
			<td>
				<code><?php echo esc_url( rest_url( 'trustlens/v1/' ) ); ?></code>
				<p class="description">
					<?php esc_html_e( 'Base URL for all TrustLens API requests.', 'trustlens' ); ?>
				</p>
			</td>
		</tr>
	</table>
</div>

<div class="wstl-card">
	<h2><?php esc_html_e( 'Available Endpoints', 'trustlens' ); ?></h2>

	<table class="wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th style="width: 100px;"><?php esc_html_e( 'Method', 'trustlens' ); ?></th>
				<th><?php esc_html_e( 'Endpoint', 'trustlens' ); ?></th>
				<th><?php esc_html_e( 'Description', 'trustlens' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td><code>GET</code></td>
				<td><code>/trustlens/v1/customers</code></td>
				<td><?php esc_html_e( 'List customers (query: segment, blocked, per_page, page, orderby, order)', 'trustlens' ); ?></td>
			</tr>
			<tr>
				<td><code>GET</code></td>
				<td><code>/trustlens/v1/customers/{hash}</code></td>
				<td><?php esc_html_e( 'Get customer by email hash', 'trustlens' ); ?></td>
			</tr>
			<tr>
				<td><code>GET</code></td>
				<td><code>/trustlens/v1/customers/lookup?email=</code></td>
				<td><?php esc_html_e( 'Get customer by email address', 'trustlens' ); ?></td>
			</tr>
			<tr>
				<td><code>PUT</code> / <code>POST</code></td>
				<td><code>/trustlens/v1/customers/{hash}</code></td>
				<td><?php esc_html_e( 'Update customer (body: is_blocked, is_allowlisted)', 'trustlens' ); ?></td>
			</tr>
			<tr>
				<td><code>GET</code></td>
				<td><code>/trustlens/v1/customers/{hash}/events</code></td>
				<td><?php esc_html_e( 'Get customer event history', 'trustlens' ); ?></td>
			</tr>
			<tr>
				<td><code>POST</code></td>
				<td><code>/trustlens/v1/customers/{hash}/recalculate</code></td>
				<td><?php esc_html_e( 'Recalculate customer trust score', 'trustlens' ); ?></td>
			</tr>
			<tr>
				<td><code>GET</code></td>
				<td><code>/trustlens/v1/stats</code></td>
				<td><?php esc_html_e( 'Get overall trust statistics', 'trustlens' ); ?></td>
			</tr>
			<tr>
				<td><code>GET</code></td>
				<td><code>/trustlens/v1/stats/segments</code></td>
				<td><?php esc_html_e( 'Get segment distribution counts', 'trustlens' ); ?></td>
			</tr>
		</tbody>
	</table>
</div>

<div class="wstl-card">
	<h2><?php esc_html_e( 'Example Request', 'trustlens' ); ?></h2>

	<pre style="background: #f1f1f1; padding: 15px; overflow-x: auto;"><code>curl -X GET "<?php echo esc_url( rest_url( 'trustlens/v1/customers' ) ); ?>" \
  -H "X-TrustLens-API-Key: YOUR_API_KEY" \
  -H "Content-Type: application/json"</code></pre>

	<h3 style="margin-top: 20px;"><?php esc_html_e( 'Example Response (list customers)', 'trustlens' ); ?></h3>
	<p class="description"><?php esc_html_e( 'Response is a JSON array of customer objects. Pagination: X-WP-Total and X-WP-TotalPages headers.', 'trustlens' ); ?></p>

	<pre style="background: #f1f1f1; padding: 15px; overflow-x: auto;"><code>[
  {
    "id": 1,
    "email_hash": "abc123...",
    "trust_score": 45,
    "segment": "caution",
    "segment_label": "Caution",
    "total_orders": 8,
    "total_refunds": 3,
    "return_rate": 37.5,
    "is_blocked": false,
    "is_allowlisted": false,
    "first_order_date": "2024-01-15",
    "last_order_date": "2024-06-01",
    "created_at": "...",
    "updated_at": "..."
  }
]</code></pre>
</div>

<?php // phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound ?>
