<?php
/**
 * Settings page template.
 *
 * @package TrustLens\Admin\Views
 * @since   1.0.0
 */

defined( 'ABSPATH' ) || exit;

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to included view file.

// Get current tab.
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Tab display only, no data changes.
$current_tab = isset( $_GET['tab'] ) ? sanitize_text_field( wp_unslash( $_GET['tab'] ) ) : 'general';

// Redirect legacy Automation tab to dedicated Automation page.
if ( 'automation' === $current_tab ) {
	wp_safe_redirect( admin_url( 'admin.php?page=trustlens-automation' ) );
	exit;
}

$tabs = array(
	'general'     => __( 'General', 'trustlens' ),
	'payment-controls' => __( 'Payment Controls', 'trustlens' ) . ( ( wstl_has_payment_method_controls() && wstl_can_use_pro() ) ? '' : ' <span class="wstl-badge-pro wstl-badge-pro-small">Pro</span>' ),
	'modules'     => __( 'Modules', 'trustlens' ),
	'webhooks'    => __( 'Webhooks', 'trustlens' ) . ( ( wstl_has_webhooks() && wstl_can_use_pro() ) ? '' : ' <span class="wstl-badge-pro wstl-badge-pro-small">Pro</span>' ),
	'reports'     => __( 'Reports', 'trustlens' ) . ( ( wstl_has_scheduled_reports() && wstl_can_use_pro() ) ? '' : ' <span class="wstl-badge-pro wstl-badge-pro-small">Pro</span>' ),
	'chargebacks' => __( 'Chargebacks', 'trustlens' ) . ( ( wstl_has_chargebacks() && wstl_can_use_pro() ) ? '' : ' <span class="wstl-badge-pro wstl-badge-pro-small">Pro</span>' ),
	'api'         => __( 'API', 'trustlens' ),
	'data'        => __( 'Data', 'trustlens' ),
);
?>

<div class="wrap wstl-wrap">
	<h1><?php esc_html_e( 'TrustLens Settings', 'trustlens' ); ?></h1>

	<nav class="nav-tab-wrapper wstl-settings-tabs">
		<?php foreach ( $tabs as $tab_id => $tab_label ) : ?>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=trustlens-settings&tab=' . $tab_id ) ); ?>"
			   class="nav-tab <?php echo $current_tab === $tab_id ? 'nav-tab-active' : ''; ?>">
				<?php echo wp_kses( $tab_label, array( 'span' => array( 'class' => array(), 'style' => array() ) ) ); ?>
			</a>
		<?php endforeach; ?>
	</nav>

	<div class="wstl-settings">
		<?php
		switch ( $current_tab ) {
			case 'payment-controls':
				include TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/payment-controls.php';
				break;
			case 'modules':
				include TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/modules.php';
				break;
			case 'webhooks':
				include TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/webhooks.php';
				break;
			case 'reports':
				include TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/reports.php';
				break;
			case 'chargebacks':
				include TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/chargebacks.php';
				break;
			case 'api':
				include TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/api.php';
				break;
			case 'data':
				include TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/data.php';
				break;
			default:
				include TRUSTLENS_PLUGIN_DIR . 'admin/views/settings/general.php';
				break;
		}
		?>
	</div>
</div>

<?php // phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound ?>
