<?php
/**
 * Email Notifications page template.
 *
 * @package TrustLens\Admin\Views
 * @since   1.1.0
 */

defined( 'ABSPATH' ) || exit;

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to included view file.

$is_pro = wstl_can_use_pro();
?>

<div class="wrap wstl-wrap">
	<h1 class="wp-heading-inline"><?php esc_html_e( 'Email Notifications', 'trustlens' ); ?></h1>
	<hr class="wp-header-end">

	<form method="post" action="options.php">
		<?php settings_fields( 'trustlens_notifications' ); ?>

		<!-- Global Settings -->
		<div class="wstl-card">
			<h2><?php esc_html_e( 'Notification Settings', 'trustlens' ); ?></h2>

			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Enable Notifications', 'trustlens' ); ?></th>
					<td>
						<label>
							<input type="hidden" name="trustlens_enable_notifications" value="0">
							<input type="checkbox" name="trustlens_enable_notifications" value="1" <?php checked( get_option( 'trustlens_enable_notifications', false ) ); ?>>
							<?php esc_html_e( 'Send email alerts for trust events', 'trustlens' ); ?>
						</label>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="trustlens_notification_email"><?php esc_html_e( 'Notification Email', 'trustlens' ); ?></label>
					</th>
					<td>
						<input type="email" id="trustlens_notification_email" name="trustlens_notification_email" value="<?php echo esc_attr( get_option( 'trustlens_notification_email', get_option( 'admin_email' ) ) ); ?>" class="regular-text">
						<p class="description">
							<?php esc_html_e( 'Email address to receive TrustLens notifications.', 'trustlens' ); ?>
						</p>
					</td>
				</tr>
			</table>
		</div>

		<!-- Standard Notifications (Free) -->
		<div class="wstl-card">
			<h2><?php esc_html_e( 'Standard Notifications', 'trustlens' ); ?></h2>
			<p class="description wstl-mb-20">
				<?php esc_html_e( 'These notifications are included with the free version of TrustLens.', 'trustlens' ); ?>
			</p>

			<table class="wstl-notifications-table widefat fixed">
				<tbody>
					<tr>
						<td class="wstl-notification-toggle">
							<label class="wstl-toggle">
								<input type="hidden" name="trustlens_notify_blocked_checkout" value="0">
								<input type="checkbox" name="trustlens_notify_blocked_checkout" value="1" <?php checked( get_option( 'trustlens_notify_blocked_checkout', true ) ); ?>>
								<span class="wstl-toggle-slider"></span>
							</label>
						</td>
						<td class="wstl-notification-info">
							<strong><?php esc_html_e( 'Blocked Checkout Alert', 'trustlens' ); ?></strong>
							<p class="description"><?php esc_html_e( 'Get notified when a blocked customer attempts to checkout. Confirms your protection is working.', 'trustlens' ); ?></p>
						</td>
					</tr>
					<tr>
						<td class="wstl-notification-toggle">
							<label class="wstl-toggle">
								<input type="hidden" name="trustlens_notify_welcome_summary" value="0">
								<input type="checkbox" name="trustlens_notify_welcome_summary" value="1" <?php checked( get_option( 'trustlens_notify_welcome_summary', true ) ); ?>>
								<span class="wstl-toggle-slider"></span>
							</label>
						</td>
						<td class="wstl-notification-info">
							<strong><?php esc_html_e( 'Welcome Summary', 'trustlens' ); ?></strong>
							<p class="description"><?php esc_html_e( 'Receive a one-time summary 24 hours after activation showing how many customers were scanned and their risk breakdown.', 'trustlens' ); ?></p>
						</td>
					</tr>
					<tr>
						<td class="wstl-notification-toggle">
							<label class="wstl-toggle">
								<input type="hidden" name="trustlens_notify_weekly_summary" value="0">
								<input type="checkbox" name="trustlens_notify_weekly_summary" value="1" <?php checked( get_option( 'trustlens_notify_weekly_summary', true ) ); ?>>
								<span class="wstl-toggle-slider"></span>
							</label>
						</td>
						<td class="wstl-notification-info">
							<strong><?php esc_html_e( 'Weekly Summary', 'trustlens' ); ?></strong>
							<p class="description"><?php esc_html_e( 'Weekly report with key stats: orders held, checkouts blocked, and money protected. Sent every Monday at 7 AM.', 'trustlens' ); ?></p>
						</td>
					</tr>
				</tbody>
			</table>
		</div>

		<!-- Pro Notifications: Pro UI in Pro build only; free build shows promotional card only -->
		<?php
		$notifications_pro_section = TRUSTLENS_PLUGIN_DIR . 'admin/views/notifications-pro-section.php';
		if ( file_exists( $notifications_pro_section ) ) {
			include $notifications_pro_section;
		} else {
			// Free build: promotional UI only.
			wstl_render_pro_upsell(
				__( 'Pro Notifications', 'trustlens' ),
				__( 'Get alerted the moment risk rises, a high-value order lands, or a chargeback is filed so your team can respond before loss grows.', 'trustlens' ),
				array(
					__( '10 advanced alert types with configurable thresholds', 'trustlens' ),
					__( 'Real-time warning coverage for high-risk and high-value behavior', 'trustlens' ),
					__( 'Daily and monthly executive summaries delivered automatically', 'trustlens' ),
				),
				array(
					array( __( 'Alert coverage', 'trustlens' ), __( '3 standard alerts', 'trustlens' ), __( '10 advanced alerts', 'trustlens' ) ),
					array( __( 'Threshold controls', 'trustlens' ), __( 'Basic', 'trustlens' ), __( 'Per-alert controls', 'trustlens' ) ),
					array( __( 'Reporting cadence', 'trustlens' ), __( 'Weekly summary', 'trustlens' ), __( 'Daily + monthly reports', 'trustlens' ) ),
				),
				__( 'Stay Ahead of Risk', 'trustlens' )
			);
		}
		?>

		<?php submit_button( __( 'Save Notification Settings', 'trustlens' ) ); ?>
	</form>

	<!-- Test Email -->
	<div class="wstl-card">
		<h2><?php esc_html_e( 'Test Notifications', 'trustlens' ); ?></h2>
		<p class="description wstl-mb-15">
			<?php esc_html_e( 'Send a test email to verify your notification settings are working correctly.', 'trustlens' ); ?>
		</p>
		<button type="button" id="wstl-send-test-notification" class="button">
			<?php esc_html_e( 'Send Test Email', 'trustlens' ); ?>
		</button>
		<span class="spinner wstl-spinner-inline"></span>
		<span id="wstl-test-notification-result" class="wstl-bulk-result"></span>
	</div>
</div>

<?php // phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound ?>
