<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Plugin Name: Trusted Clients
 * Description: Muestra una fila de hasta 6 fotos de clientes con un texto personalizado y estrellas, mediante el shortcode [trusted_clients].
 * Version: 1.3
 * Author: Nico Arche
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: trusted-clients
 * Domain Path: /languages
 */

// Cargar traducciones
add_action('plugins_loaded', 'trusted_clients_load_textdomain');
function trusted_clients_load_textdomain() {
    load_plugin_textdomain('trusted-clients', false, dirname(plugin_basename(__FILE__)) . '/languages');
}

// Incluir panel de administración
require_once plugin_dir_path(__FILE__) . 'admin-panel.php';

// Shortcode
add_shortcode('trusted_clients', 'trusted_clients_render_shortcode');

function trusted_clients_render_shortcode() {
    $total_fotos = intval(get_option('trusted_clients_total_fotos', 6));
    $total_fotos = min($total_fotos, 20);

    $cantidad_mostrar = intval(get_option('trusted_clients_fotos_mostrar', 6));
    $cantidad_mostrar = min(max($cantidad_mostrar, 1), 6);

    $fotos = [];
    for ($i = 1; $i <= $total_fotos; $i++) {
        $foto_url = get_option("trusted_clients_foto_$i");
        if (!empty($foto_url)) {
            $img_html = '<img src="' . esc_url($foto_url) . '" class="ccp-avatar" alt="' . esc_attr__('Cliente', 'trusted-clients') . '">';
            $fotos[] = $img_html;
        }
    }

    $aleatorio = intval(get_option('trusted_clients_aleatorio', 0));
    if ($aleatorio && count($fotos) > $cantidad_mostrar) {
        shuffle($fotos);
    }

    $fotos_mostrar = array_slice($fotos, 0, $cantidad_mostrar);
    $texto = esc_html(get_option('trusted_clients_texto'));
    $mostrar_estrellas = intval(get_option('trusted_clients_mostrar_estrellas', 1));

    ob_start();
    ?>
    <div class="ccp-wrapper">
        <div class="ccp-fotos">
            <?php foreach ($fotos_mostrar as $foto_html): ?>
                <?php echo wp_kses_post($foto_html); ?>
            <?php endforeach; ?>
        </div>
        <div class="ccp-texto">
            <?php if ($mostrar_estrellas): ?>
                <div class="ccp-estrellas">
                    <?php for ($j = 0; $j < 5; $j++): ?>
                        <span class="ccp-estrella">&#9733;</span>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>
            <?php echo esc_html($texto); ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

// Estilos
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style(
        'trusted_clients_style',
        plugin_dir_url(__FILE__) . 'style.css',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'style.css')
    );
});
