jQuery(document).ready(function($) {
    var ultimaTab = localStorage.getItem('trusted_clients_tab_activa');
    if (ultimaTab && $(ultimaTab).length) {
        $('.nav-tab').removeClass('nav-tab-active');
        $('.trusted-clients-tab-content').removeClass('active');
        $('.nav-tab[href="' + ultimaTab + '"]').addClass('nav-tab-active');
        $(ultimaTab).addClass('active');
        const focoTrampa = $('<input type="text" style="position:absolute;opacity:0;height:1px;width:1px;border:none;padding:0;margin:0;top:-9999px;">');
        $('body').append(focoTrampa);
        focoTrampa.focus();
        setTimeout(() => focoTrampa.remove(), 100);
    }

    $('.nav-tab').click(function(e) {
        e.preventDefault();
        $('.nav-tab').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');
        $('.trusted-clients-tab-content').removeClass('active');
        var tabId = $(this).attr('href');
        $(tabId).addClass('active');
        localStorage.setItem('trusted_clients_tab_activa', tabId);
    });

    $(document).on('click', '.trusted-clients-media-upload', function(e) {
        e.preventDefault();
        var targetInput = $(this).data('target');
        var inputField = $('#' + targetInput);
        var gridItem = inputField.closest('.trusted-clients-grid-item');
        var thumbnailContainer = gridItem.find('.trusted-clients-thumbnail');
        var customUploader = wp.media({
            title: 'Seleccionar imagen',
            button: { text: 'Usar esta imagen' },
            multiple: false
        }).on('select', function() {
            var attachment = customUploader.state().get('selection').first().toJSON();
            inputField.val(attachment.url);
            thumbnailContainer.html('<img src="' + attachment.url + '" alt="Vista previa" />');
        }).open();
    });

    $(document).on('click', '#trusted-clients-agregar-foto', function() {
        var total = $('.trusted-clients-grid-item').length;
        var next = total + 1;
        $('#trusted_clients_total_fotos').val(next);
        var rowID = 'trusted-clients-row-' + next;
        var inputID = 'trusted_clients_foto_' + next;
        var newItem = `
            <div class="trusted-clients-grid-item" id="${rowID}">
                <label><strong>Foto #${next}</strong></label>
                <div class="trusted-clients-thumbnail"></div>
                <input type="text" name="${inputID}" id="${inputID}" class="regular-text" />
                <div class="trusted-clients-grid-buttons">
                    <button type="button" class="button trusted-clients-media-upload" data-target="${inputID}">Seleccionar</button>
                    <button type="button" class="button trusted-clients-remove-foto" data-row="${rowID}">Eliminar</button>
                </div>
            </div>`;
        $('#trusted-clients-fotos-container').append(newItem);
    });

    $(document).on('click', '.trusted-clients-remove-foto', function () {
        $('#' + $(this).data('row')).remove();
        let total = $('.trusted-clients-grid-item').length;
        $('#trusted_clients_total_fotos').val(total);
    });

    $(document).on('click', '.trusted-clients-frase', function (e) {
        e.preventDefault();
        $('textarea[name="trusted_clients_texto"]').val($(this).data('frase'));
    });

    const focoTrampa = $('<input type="text" style="position:absolute;opacity:0;height:1px;width:1px;border:none;padding:0;margin:0;top:-9999px;">');
    $('body').append(focoTrampa);
    focoTrampa.focus();
    setTimeout(() => focoTrampa.remove(), 100);
});
