<?php 
/*
 # Written 2022
 #   by Jeffrey Quade 
**/
?>
<?php

require_once('wpp_config.php');



if (!function_exists('wpp_tron_login_protect_settings_page')) {
	
	global $options_r; 
	
	// mt_settings_page() displays the page content for the settings submenu
	function wpp_tron_login_protect_settings_page() {

		//must check that the user has the required capability 
		if (!current_user_can('manage_options')) {
			wp_die(__('You do not have sufficient permissions to access this page.'));
		}
	
		// variables for the field and option names 	
		if (!empty($_POST['tron_posted']) && sanitize_text_field($_POST['tron_posted'] == 'Y')) {
		
			// Save the posted value in the database
			if (empty($_POST['tron_login_protect_pin'])) 
				$_POST['tron_login_protect_pin'] = ""; // Bug fix 2025. 
				
			$message = ""; 
			$new_pin = sanitize_text_field($_POST['tron_login_protect_pin']); 
			if (is_numeric($new_pin) && strlen($new_pin) >= 4) { // Validate numbers only allowed. 
				update_option('tron_login_protect_pin', $new_pin);
			} else $message = "Only numbers are allowed. Minimum 4 digits."; 
			
			// Put an settings updated message on the screen
	?>
			<div class="updated"><p><strong>
				<?php 
				if (empty($message)) _e(esc_html(sanitize_text_field('Settings Saved')));
					else _e(esc_html(sanitize_text_field($message))); 
				?>
      </strong></p></div>
	<?php
		}
		// Now display the settings editing screen
		?>


<div class="wrap">

	<script>
  function jsCopyTextFunction() {
    var e = document.getElementById('tron_login_protect_pin');
    if (e) {
      navigator.clipboard.writeText(e.value).then(() => {
        alert('Copied!');
      }).catch(err => {
        console.error('Could not copy text: ', err);
      });
      return false;
      
    } // if (e)
  } // jsCopyTextFunction
  </script>
  
  <script type="text/javascript">
  function jsOnKeypressNumbersOnly(evt) {
    
    var key = (evt.keyCode) ? evt.keyCode : evt.charCode; // FF fix, key in charCode.
    if (evt.keyCode == 46 && evt.which == 0 && evt.charCode == 0 && !evt.char) 
      return true; // Delete key pressed in FF. 
  
    if (window.event) ctrlDown = window.event.ctrlKey; // Don't care about altKey or shiftKey
      else ctrlDown = evt.ctrlKey || evt.metaKey; // Mac support
    if (ctrlDown) return true;
    return (
      key <= 31 || 
        (key >= "0".charCodeAt(0) && key <= "9".charCodeAt(0)) 
    );
  } 
  </script>
  
  <h2>Tron Login Protect
  <?php 
	
	$plugins_url = plugins_url(); // https://www.domain.com/wp-content/plugins
	$myImage = $plugins_url . '/tron-login-protect/assets/images/tronusa-logo_250x87.png';
	
  // settings form
  ?>
  </h2>
  <a href="https://www.jeffquade.net" target="_blank">
  <img src='<?php echo $myImage; ?>'  width="143" height="49" alt="Tron Company Logo" title="Visit Jeff's Site" />
  </a>
      
  <form name="form1" method="post" action="" autocomplete="off">
  
    <input type="hidden" name="tron_posted" value="Y">
    
    <div style="height:auto; width:500px; border-bottom:1px dotted #AAA; margin:0; padding-bottom:5px;">
<?php
//require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
$plugin_dir = WP_PLUGIN_DIR . '/tron-login-protect/main.php';
$plugin_data_r = get_plugin_data($plugin_dir);
?>
    	<strong>Settings (version <?php echo $plugin_data_r['Version'] ?>): </strong>
    </div>
    
    <p>Please enter a 4-8 digit pin: 
    <?php $tron_login_protect_pin = sanitize_text_field(get_option('tron_login_protect_pin')); 
		// echo 'pin is " '; echo($tron_login_protect_pin); echo ' "'; die(); 
		?><br>
    <input type="password" id="tron_login_protect_pin" name="tron_login_protect_pin" autocomplete="new-password" value="<?php _e(esc_html($tron_login_protect_pin)); ?>" size="8" maxlength="8" onKeyPress="return jsOnKeypressNumbersOnly(event || window.event);" /> <a title='show or hide'><span onclick="var e=document.getElementById('tron_login_protect_pin'); e.type=(e.type==='password')?'text':'password'">👁️</span></a>
    </p>
    
    <p class="submit">
    	<input type="submit" name="Submit" class="button-primary" value="Save Changes" />
    </p>
  </form>
  
  <p>To access your wp-admin area go to . . . </p>
  <?php $url_link = sanitize_text_field(get_site_url() . '/wp-login.php?pin=' . get_option('tron_login_protect_pin')); ?>
  <a href="<?php _e(esc_html($url_link)); ?>" target="_blank"><span id="tron_login_protect_url"><?php _e($url_link); ?></span></a> 

  <button id="copyButton">Copy URL</button>
  
  <script>
  // Select the elements
  const copyButton = document.getElementById("copyButton");
  const spanElement = document.getElementById("tron_login_protect_url");
  
  copyButton.addEventListener("click", function() {
    const text = spanElement.textContent;
    
    navigator.clipboard.writeText(text).then(function() {
      console.log("Text successfully copied to clipboard");
      alert("Text copied:\n " + text);
    }).catch(function(err) {
      console.error("Failed to copy text: ", err);
    });
  });
  </script>

</div><!-- <div class="wrap"> -->


	<?php
	} // function wpp_tron_login_protect_settings_page()
} // if (!function_exists('wpp_tron_login_protect_settings_page'))
