<?php 
/*
 # Written 2022-2026
 #   by Jeffrey Quade 
**/
?>
<?php

if (!function_exists('tron_login_protect_plus_can_redirect_on_activation')) {
function tron_login_protect_plus_can_redirect_on_activation() {

	// If plugin is activated in network admin options, skip redirect.
	if (is_network_admin()) {
		return false;
	}

	// Skip redirect if WP_DEBUG is enabled.
	if (defined('WP_DEBUG') && WP_DEBUG) {
		return false;
	}

	// Determine if multi-activation is enabled.
	$maybe_multi = filter_input(INPUT_GET, 'activate-multi', FILTER_VALIDATE_BOOLEAN);
	if ($maybe_multi) {
		return false;
	}

	// All is well. Can redirect.
	return true;
}
}

// Function to run on plugin activation
if (!function_exists('tron_login_protect_activate')) {
function tron_login_protect_activate() {
	set_transient('tron_login_protect_activation_redirect', true, 120);
}
// Must be main plugin file. New plugins always main.php
register_activation_hook(dirname(__FILE__) . '/main.php', 'tron_login_protect_activate');
}

// Function to handle the redirection
if (!function_exists('tron_login_protect_redirect')) {
function tron_login_protect_redirect() {
	
	if (get_transient('tron_login_protect_activation_redirect') 
		&& current_user_can('manage_options')
	) {
		delete_transient('tron_login_protect_activation_redirect');
		if (tron_login_protect_plus_can_redirect_on_activation())
			wp_safe_redirect(admin_url('options-general.php?page=tron-login-protect')); 
		exit;
	}
}
add_action('admin_init', 'tron_login_protect_redirect');
}
