<?php
/*
	Plugin Name:       Tron Login Protect
	Description:       Protect your wp-admin area with a private pin
	Version:           1.0.6
	Author:            Jeff Quade aka Tron
	Author URI:        https://www.JeffQuade.net
	License:           GPL v2 or later
	License URI:       https://www.gnu.org/licenses/gpl-2.0.html
	Requires PHP:      7.4
	Tested up to:      6.9.1
*/
// update version to 1.0.6 before publish #########################
require_once('wpp_config.php');
require_once('wpp_row_meta.php'); 
require_once('wpp_activation.php');
require_once('wpp_deactivation.php');
require_once('wpp_menus.php');
require_once('wpp_settings_page.php'); 

// If not logged in, check for valid pin number, if not go to the 404 page. 
if (!function_exists('tron_login_protect_wp_admin_headers')) {
function tron_login_protect_wp_admin_headers() {
	
	if (!is_user_logged_in()) {
		$saved_pin = sanitize_text_field(get_option('tron_login_protect_pin')); 
		if (!empty($saved_pin)) {
			$url_pin = ""; 
			if (!empty($_GET['pin'])) $url_pin = sanitize_text_field($_GET['pin']);  
			if ($saved_pin != $url_pin) { 
				header('HTTP/1.1 401 Unauthorized'); 
				$site_url = sanitize_text_field(get_site_url()); // same as https://{$_SERVER['HTTP_HOST']}
				//$site_url = sanitize_text_field($site_url); 
				header("Location: $site_url/404/"); 
			}
		}
	} // !is_user_logged_in 
	
}
add_action('login_init', 'tron_login_protect_wp_admin_headers');
}

// Avoid 404 page on logout. 
if (!function_exists('tron_login_protect_auto_redirect_after_logout')) {
function tron_login_protect_auto_redirect_after_logout(){
	$saved_pin = sanitize_text_field(get_option('tron_login_protect_pin'));
  wp_safe_redirect(home_url() . "/wp-login.php?pin=$saved_pin&logout=true");
  exit;
}
add_action('wp_logout','tron_login_protect_auto_redirect_after_logout');
}
