<?php
/**
 * Plugin Name:       Triopsi Block Visibility
 * Description:       Adds a toggle to the block inspector allowing you to hide individual blocks on mobile devices by applying a `hide-mobile` CSS class.
 * Version: 2.0.0
 * Requires at least: 6.9
 * Requires PHP:      8.0
 * Author:            triopsi
 * Author URI:        https://triopsi.dev
 * License:           GPLv2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       triopsi-block-visibility
 *
 * @package TriopsiBlockVisibility
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Define plugin version as a constant for use in enqueuing assets.
define( 'TRBLVI_VERSION', '2.0.0' );

/**
 * Enqueue frontend CSS globally (so `hide-mobile` works even if the demo block is not used).
 */
function trblvi_enqueue_frontend_styles() {
	// For development: use filemtime for cache busting, otherwise use the defined version.
	$frontend_css_path = plugin_dir_path( __FILE__ ) . 'build/frontend.css';
	$frontend_css_url  = plugin_dir_url( __FILE__ ) . 'build/frontend.css';
	$ver               = defined( 'WP_DEBUG' ) && WP_DEBUG
		? (string) filemtime( $frontend_css_path )
		: TRBLVI_VERSION;

	wp_enqueue_style(
		'triopsi-block-visibility-frontend',
		$frontend_css_url,
		array(),
		$ver
	);
}
add_action( 'wp_enqueue_scripts', 'trblvi_enqueue_frontend_styles' );

/**
 * Enqueue editor CSS globally (visual marking only).
 * This file is generated by create-block from src/editor.scss -> build/index.css
 */
function trblvi_enqueue_editor_styles() {
	// For development: use filemtime for cache busting, otherwise use the defined version.
	$editor_css_path = plugin_dir_path( __FILE__ ) . 'build/editor.css';
	$editor_css_url  = plugin_dir_url( __FILE__ ) . 'build/editor.css';
	$ver             = defined( 'WP_DEBUG' ) && WP_DEBUG
		? (string) filemtime( $editor_css_path )
		: TRBLVI_VERSION;

	wp_enqueue_style(
		'triopsi-block-visibility-editor',
		$editor_css_url,
		array( 'wp-edit-blocks' ),
		$ver
	);
}
add_action( 'enqueue_block_editor_assets', 'trblvi_enqueue_editor_styles' );

/**
 * Enqueue the add-on script globally in the block editor.
 * This ensures the filters (toggle + class) run for core blocks like core/image.
 */
function trblvi_enqueue_editor_script() {
	// For development: use filemtime for cache busting, otherwise use the defined version.
	$editor_js_path = plugin_dir_path( __FILE__ ) . 'build/editor.js';
	$editor_js_url  = plugin_dir_url( __FILE__ ) . 'build/editor.js';
	$ver            = defined( 'WP_DEBUG' ) && WP_DEBUG
		? (string) filemtime( $editor_js_path )
		: TRBLVI_VERSION;

	$dependencies = array(
		'wp-blocks',
		'wp-element',
		'wp-block-editor',
		'wp-i18n',
		'wp-hooks',
		'wp-compose',
		'wp-components',
	);

	wp_enqueue_script(
		'triopsi-block-visibility-editor-script',
		$editor_js_url,
		$dependencies,
		$ver,
		true
	);

	// Set script translations for localization
	// To add translations: create languages/triopsi-block-visibility-de_DE.po/mo files.
	wp_set_script_translations(
		'triopsi-block-visibility-editor-script',
		'triopsi-block-visibility',
		plugin_dir_path( __FILE__ ) . 'languages'
	);
}
add_action( 'enqueue_block_editor_assets', 'trblvi_enqueue_editor_script' );
