<?php if ( ! defined( 'ABSPATH' ) ) exit;

/*
 * Plugin Name: TriggerNinja - Actions for Ninja Forms
 * Requires Plugins: ninja-forms
 * Plugin URI: https://triggerninja.com
 * Description: Connect Ninja Forms to marketing and CRM platforms with this independent TriggerNinja add-on.
 * Version: 1.0.0
 * Author: TriggerNinja
 * Text Domain: triggerninja-for-ninja-forms
 * Domain Path: /lang
 * License: GPLv2 or later
 */

if( get_option( 'ninja_forms_load_deprecated', FALSE ) ) return;
if( version_compare( get_option( 'ninja_forms_version', '0.0.0' ), '3', '<' ) ) return;

require_once plugin_dir_path( __FILE__ ) . 'includes/autoload.php';
triggerninja_composer_autoloader();

if( ! function_exists( 'triggerninja_instance' ) ) {
    function triggerninja_instance()
    {
        static $instance;
        if( ! isset( $instance ) ) {
            $instance = new TriggerNinja_Plugin( '1.0.0', __FILE__ );
            $instance->init();
        }
        return $instance;
    }
}
triggerninja_instance();

// Plugin activation hook
register_activation_hook( __FILE__, 'triggerninja_activation_callback' );

/**
 * Plugin activation callback
 */
function triggerninja_activation_callback() {
    // Create database tables
    TriggerNinja_Logger::create_table();
    
    // Set default logging option
    if ( get_option( 'triggerninja_enable_logging' ) === false ) {
        update_option( 'triggerninja_enable_logging', true );
    }
}

function triggerninja_composer_autoloader(): bool {
    $autoloader = dirname(__FILE__) . '/vendor/autoload.php';

    if (file_exists($autoloader)) {
        include_once $autoloader;
        $return = true;
    } else {
        $return = false;
    }
    return $return;
}
